% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_twn}
\alias{read_twn}
\alias{get_worms}
\alias{validate_twn}
\title{Read and Validate Taxa Waterbeheer Nederland (TWN) Data}
\usage{
read_twn(filename)

get_worms()

validate_twn(.data)
}
\arguments{
\item{filename}{name of TWN file (\code{character})}

\item{.data}{table in TWN-format}
}
\value{
a \code{data_frame} with four columns:
 \itemize{
		\item{GROUP} {TWN/WoRMS taxon group}
 	\item{LEVEL} {TWN/WoRMS taxon level}
 	\item{FROM} {taxon name to convert from}
     \item{TO} {taxon name to convert to}
	}
}
\description{
This function reads files in the Taxa Waterbeheer Nederland (TWN) format.
}
\details{
The function adds a new column \code{taxon}. Its contents depending 
    on TWN-status:
\itemize{
		\item{status = 10} {taxonname}
 	\item{status = 20} {prefername}
 	\item{status = 80} {parentname}
	}
}
\section{Functions}{
\itemize{
\item \code{get_worms}: get default WoRMS list (TWN list extended with species Southern North Sea)

\item \code{validate_twn}: validator for TWN-format
}}

\references{
\url{sofus.ecosys.nl/taxabase.htm}

\url{www.aquo.nl/faq/faq-twn}
}
