% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movAvLines.R
\name{movAvLines}
\alias{movAvLines}
\title{Moving average with different window widths}
\usage{
movAvLines(y, x = 1:length(y), widths = 2:7 * 2 - 1, weights,
  col = "blue", alpha = 0.3, plot = FALSE, las = 1, ...)
}
\arguments{
\item{y}{y values that are smoothed with several window widths}

\item{x}{x values of data. DEFAULT: 1:length(y)}

\item{widths}{widths of \code{\link{movAv}} windows. DEFAULT: 2:7*2-1}

\item{weights}{weights within each window}

\item{col}{color passed to \code{\link{addAlpha}}. DEFAULT: "blue"}

\item{alpha}{transparency passed to \code{\link{addAlpha}}. DEFAULT: 0.3}

\item{plot}{should scatterplot be created first? DEFAULT: FALSE}

\item{las}{LabelAxisStyle (only relevant if plot=TRUE). DEFAULT: 1}

\item{\dots}{further arguments passed to \code{\link{lines}}}
}
\description{
Add moving average lines with different window widths to a plot
}
\examples{

set.seed(42)
movAvLines(cumsum(rnorm(50)), plot=TRUE, lwd=3)

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2015
}
\seealso{
\code{\link{movAv}}, \code{\link{addAlpha}}
}
\keyword{manip}
\keyword{smooth}
\keyword{ts}

