% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/between.R
\name{between}
\alias{between}
\title{Are values between a and b?}
\usage{
between(x, a, b = a, incl = TRUE, aincl = incl, bincl = incl,
  quiet = FALSE)
}
\arguments{
\item{x}{Numerical vector}

\item{a, b}{Numerical values/vectors specifying the borders of the interval.
\code{\link{min}} and \code{max} are used, so they can be a vector.}

\item{incl}{Logical. Include values on the borders? For x == border, TRUE
will be returned. Specify per left and right border separately
with the arguments \code{aincl} and \code{bincl}. DEFAULT: TRUE}

\item{aincl, bincl}{Logical. Include values on left and right border, respectively?
DEFAULT: \code{incl}}

\item{quiet}{Logical. Suppress warning if a>b? DEFAULT: FALSE}
}
\value{
Logical (boolean) vector with TRUE/FALSE values
}
\description{
Are values within a certain interval?
Basically a wrapper for \code{ x >= a   &   x <= b } to save repeating long x names twice.
}
\examples{
between(1:10, 4, 8)
between(1:10, 4:8) # range as vector
between(1:10, 8, 4) # warns about interval

data.frame( incl.T=between(1:10, 4, 8),
            incl.F=between(1:10, 4, 8,  incl=FALSE),
           aincl.F=between(1:10, 4, 8, aincl=FALSE),
           bincl.F=between(1:10, 4, 8, bincl=FALSE)  )

}
\seealso{
\code{\link{findInterval}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Aug 2017
}
\keyword{logic}
