% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logSpaced.R
\name{logSpaced}
\alias{logSpaced}
\title{Logarithmically spaced points}
\usage{
logSpaced(
  base = 1.1708,
  n = 20,
  min = 1,
  max = n,
  plot = TRUE,
  pch = 3,
  las = 1,
  ylab = "base",
  ...
)
}
\arguments{
\item{base}{Base for calculations, can be a vector to compare several bases. DEFAULT: 1.1708}

\item{n}{Number of values to be calculated. DEFAULT: 30}

\item{min, max}{Range where n values are to be distributed, single values each. DEFAULT: 1,n}

\item{plot}{Should the points be plotted on a line? DEFAULT: TRUE}

\item{pch, las}{PointCharacter and Label Axis Style. DEFAULT: 3,1}

\item{ylab}{Y axis label. DEFAULT: "base"}

\item{\dots}{Further arguments passed to \code{\link{plot}}}
}
\value{
Vector or matrix, depending on base input
}
\description{
Calculates values that are in logarithmic distance from each other
e.g. to produce logarithmic interval borders.\cr
For exact logarithmic spacing, use
\code{10^\link{seq}(from=\link{log10}(1), to=\link{log10}(100), len=100)}
}
\note{
base >1 concentrates points at low values, base<1 at high values.
      \code{base} does not relate to \code{base} in \code{\link{log}}!
}
\examples{

logSpaced()
logSpaced(base=c(1.1, 1.5, 2), n=6, min=5, max=10)
d <- logSpaced(seq(0.8, 1.2, 0.025), main="logarithmically spaced points")

# the default base for the default n (20) will give an approximately equal
# bin width across the range on a logarithmic scale:
d <- logSpaced()
plot(d, rep(1,20), log="x")

# For exactly spacing logarithmically, use
plot(10^seq(from=log10(1), to=log10(100), len=100), log="y")
browseURL("https://stackoverflow.com/a/29963530")

}
\seealso{
\code{\link{classify}}, \code{\link{log}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Oct 2014
}
\keyword{arith}
