% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambert.R
\name{lambert}
\alias{lambert}
\alias{predict.lambert}
\alias{predict.lambert}
\alias{print.lambert}
\title{Lambert W x F Normalization}
\usage{
lambert(x, type = "s", ...)

\method{predict}{lambert}(object, newdata = NULL, inverse = FALSE, ...)

\method{print}{lambert}(x, ...)
}
\arguments{
\item{x}{A vector to normalize with Box-Cox}

\item{type}{a character indicating which transformation to perform (options 
are "s", "h", and "hh", see details)}

\item{...}{Additional arguments that can be passed to the 
LambertW::Gaussianize function}

\item{object}{an object of class 'lambert'}

\item{newdata}{a vector of data to be (reverse) transformed}

\item{inverse}{if TRUE, performs reverse transformation}
}
\value{
A list of class \code{lambert} with elements 
  \item{x.t}{transformed original data} 
  \item{x}{original data} 
  \item{mean}{mean of vector} 
  \item{sd}{sd of vector post-BC transformation} 
  \item{tau.mat}{estimated parameters of LambertW::Gaussianize} 
  \item{n}{number of nonmissing observations}
  \item{norm_stat}{Pearson's P / degrees of freedom}
  
The \code{predict} function returns the numeric value of the transformation 
performed on new data, and allows for the inverse transformation as well.
}
\description{
Perform Lambert's W x F transformation and center/scale a vector
  to attempt normalization via the \code{LambertW} package.
}
\details{
\code{lambert} uses the \code{LambertW} package to estimate a 
  normalizing (or "Gaussianizing") transformation. This transformation can be
  performed on new data, and inverted, via the \code{predict} function.
  
  NOTE: The type = "s" argument is the only one that does the 1-1 transform
  consistently, and so it is the only method currently used in
  \code{bestNormalize()}. Use type = "h" or type = 'hh' at risk of not having
  this estimate 1-1 transform. These alternative types are effective when the
  data has exceptionally heavy tails, e.g. the Cauchy distribution.
  
  Additionally, sometimes (depending on the distribution) this method will be
  unable to extrapolate beyond the observed bounds. In these cases, NaN is
  returned.
}
\examples{
x <- rgamma(100, 1, 1)

lambert_obj <- lambert(x)
lambert_obj
p <- predict(lambert_obj)
x2 <- predict(lambert_obj, newdata = p, inverse = TRUE)

all.equal(x2, x)

}
\references{
Georg M. Goerg (2016). LambertW: An R package for Lambert W x F 
  Random Variables. R package version 0.6.4.
  
  Georg M. Goerg (2011): Lambert W random variables - a new family of 
  generalized skewed distributions with applications to risk estimation. 
  Annals of Applied Statistics 3(5). 2197-2230.
  
  Georg M. Goerg (2014): The Lambert Way to Gaussianize heavy-tailed data 
  with the inverse of Tukey's h transformation as a special case. The 
  Scientific World Journal.
}
\seealso{
\code{\link[LambertW]{Gaussianize}}
}
