% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.bestNormalize}
\alias{plot.bestNormalize}
\alias{plot.orderNorm}
\alias{plot.boxcox}
\alias{plot.yeojohnson}
\alias{plot.lambert}
\title{Transformation plotting}
\usage{
\method{plot}{bestNormalize}(
  x,
  inverse = FALSE,
  bounds = NULL,
  cols = NULL,
  methods = NULL,
  leg_loc = "top",
  ...
)

\method{plot}{orderNorm}(x, inverse = FALSE, bounds = NULL, ...)

\method{plot}{boxcox}(x, inverse = FALSE, bounds = NULL, ...)

\method{plot}{yeojohnson}(x, inverse = FALSE, bounds = NULL, ...)

\method{plot}{lambert}(x, inverse = FALSE, bounds = NULL, ...)
}
\arguments{
\item{x}{a fitted transformation}

\item{inverse}{if TRUE, plots the inverse transformation}

\item{bounds}{a vector of bounds to plot for the transformation}

\item{cols}{a vector of colors to use for the transforms (see details)}

\item{methods}{a vector of transformations to plot}

\item{leg_loc}{the location of the legend on the plot}

\item{...}{further parameters to be passed to \code{plot} and \code{lines}}
}
\description{
Plots transformation functions for objects produced by the bestNormalize
package
}
\details{
The plots produced by the individual transformations are simply
  plots of the original values by the newly transformed values, with a line
  denoting where transformations would take place for new data.

  For the bestNormalize object, this plots each of the possible
  transformations run by the original call to bestNormalize. The first
  argument in the "cols" parameter refers to the color of the chosen
  transformation.
}
