% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.bsrr.R
\name{print.bsrr}
\alias{print.bsrr}
\title{print method for a "bsrr" object}
\usage{
\method{print}{bsrr}(x, digits = max(5, getOption("digits") - 5), nonzero = FALSE, ...)
}
\arguments{
\item{x}{A "\code{bsrr}" object.}

\item{digits}{Minimum number of significant digits to be used.}

\item{nonzero}{Whether the output should only contain the non-zero coefficients.}

\item{\dots}{additional print arguments}
}
\value{
No return value, called for side effect
}
\description{
Print the primary elements of the "\code{bsrr}" object.
}
\details{
prints the fitted model and returns it invisibly.
}
\examples{

# Generate simulated data
n = 200
p = 20
k = 5
rho = 0.4
seed = 10
Tbeta <- rep(0, p)
Tbeta[1:k*floor(p/k):floor(p/k)] <- rep(1, k)
Data = gen.data(n, p, k, rho, family = "gaussian", beta = Tbeta, seed=seed)
lambda.list = exp(seq(log(5), log(0.1), length.out = 10))
lm.bsrr = bsrr(Data$x, Data$y, lambda.list = lambda.list, method = "sequential")

print(lm.bsrr)

}
\references{
Wen, C., Zhang, A., Quan, S. and Wang, X. (2020). BeSS: An R
Package for Best Subset Selection in Linear, Logistic and Cox Proportional
Hazards Models, \emph{Journal of Statistical Software}, Vol. 94(4).
doi:10.18637/jss.v094.i04.
}
\seealso{
\code{\link{bsrr}}, \code{\link{coef.bsrr}}.
}
\author{
Canhong Wen, Aijun Zhang, Shijie Quan, Liyuan Hu, Kangkang Jiang, Yanhang Zhang, Jin Zhu and Xueqin Wang.
}
