% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-beta-mc.R
\name{BetaMC}
\alias{BetaMC}
\title{Estimate Standardized Regression Coefficients
and Generate Sampling Distributions
Using the Monte Carlo Method}
\usage{
BetaMC(
  object,
  R = 20000L,
  type = "hc3",
  g1 = 1,
  g2 = 1.5,
  k = 0.7,
  decomposition = "eigen",
  pd = TRUE,
  tol = 1e-06
)
}
\arguments{
\item{object}{Object of class \code{lm}.}

\item{R}{Positive integer.
Number of Monte Carlo replications.}

\item{type}{Character string.
Sampling covariance matrix type.
Possible values are
\code{"mvn"},
\code{"adf"},
\code{"hc0"},
\code{"hc1"},
\code{"hc2"},
\code{"hc3"},
\code{"hc4"},
\code{"hc4m"}, and
\code{"hc5"}.
\code{type = "mvn"} uses the normal-theory sampling covariance matrix.
\code{type = "adf"} uses the asymptotic distribution-free
sampling covariance matrix.
\code{type = "hc0"} through \code{hc5} uses different versions of
heteroskedasticity-consistent sampling covariance matrix.}

\item{g1}{Numeric.
\code{g1} value for \code{type = "hc4m"} or \code{type = "hc5"}.}

\item{g2}{Numeric.
\code{g2} value for \code{type = "hc4m"}.}

\item{k}{Numeric.
Constant for \code{type = "hc5"}}

\item{decomposition}{Character string.
Matrix decomposition of the sampling variance-covariance matrix
for the data generation.
If \code{decomposition = "chol"}, use Cholesky decomposition.
If \code{decomposition = "eigen"}, use eigenvalue decomposition.
If \code{decomposition = "svd"}, use singular value decomposition.}

\item{pd}{Logical.
If \code{pd = TRUE},
check if the sampling variance-covariance matrix
is positive definite using \code{tol}.}

\item{tol}{Numeric.
Tolerance used for \code{pd}.}
}
\value{
Returns an object of class \code{betamc}
which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{lm}{Object of class \code{lm}.}
\item{type}{Standard error type.}
\item{beta}{Vector of standardized slopes.}
\item{vcov}{Sampling covariance matrix of the standardized slopes.}
\item{thetahatstar}{Sampling distribution
of estimates of standardized slopes.}
\item{n}{Sample size.}
\item{p}{Number of regressors.}
\item{df}{\eqn{n - p - 1} degrees of freedom.}
}
}
\description{
Estimate Standardized Regression Coefficients
and Generate Sampling Distributions
Using the Monte Carlo Method
}
\details{
The empirical sampling distribution
of parameter estimates for the unstandardized regression model
is generated using the Monte Carlo method,
that is, random values of parameter estimates
are sampled from the multivariate normal distribution
using the estimated parameter vector as the mean vector
and the specified sampling covariance matrix using the \code{type} argument
as the covariance matrix.
The standardized regression coefficients are derived
from each randomly generated vector of parameters
to generate the empirical sampling distribution
of estimates of standardized slopes.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of standardized slopes,
where \eqn{\alpha} is the significance level.
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
out <- BetaMC(object, R = 100)
# use a large R, for example, R = 20000 for actual research
# Methods -------------------------------------------------------
print(out)
summary(out)
coef(out)
vcov(out)
confint(out, level = 0.95)
}
\references{
Dudgeon, P. (2017).
Some improvements in confidence intervals
for standardized regression coefficients.
\emph{Psychometrika}, \emph{82}(4), 928–951.
\doi{10.1007/s11336-017-9563-z}

Preacher, K. J., & Selig, J. P. (2012).
Advantages of Monte Carlo confidence intervals for indirect effects.
\emph{Communication Methods and Measures}, \emph{6}(2), 77-98.
\doi{10.1080/19312458.2012.679848}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Monte Carlo Functions}
\keyword{betaMC}
