% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-r-sq-nb.R
\name{RSqNB}
\alias{RSqNB}
\title{Estimate Multiple Correlation Coefficients
(R-Squared and Adjusted R-Squared)
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping}
\usage{
RSqNB(object, alpha = c(0.05, 0.01, 0.001))
}
\arguments{
\item{object}{Object of class \code{nb}, that is,
the output of the \code{NB()} function.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.}
}
\value{
Returns an object
of class \code{betanb} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{thetahatstar}{Sampling distribution of
\eqn{R^{2}} and \eqn{\bar{R}^{2}}.}
\item{vcov}{Sampling variance-covariance matrix of
\eqn{R^{2}} and \eqn{\bar{R}^{2}}.}
\item{est}{Vector of estimated
\eqn{R^{2}} and \eqn{\bar{R}^{2}}.}
\item{fun}{Function used ("RSqNB").}
}
}
\description{
Estimate Multiple Correlation Coefficients
(R-Squared and Adjusted R-Squared)
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping
}
\details{
R-squared (\eqn{R^{2}}) and
adjusted R-squared (\eqn{\bar{R}^{2}})
is estimated from bootstrap samples.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of \eqn{R^{2}} and \eqn{\bar{R}^{2}},
where \eqn{\alpha} is the significance level.
}
\examples{
# Data ---------------------------------------------------------------------
data("nas1982", package = "betaNB")

# Fit Model in lm ----------------------------------------------------------
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)

# NB -----------------------------------------------------------------------
nb <- NB(
  object,
  R = 100, # use a large value e.g., 5000L for actual research
  seed = 0508
)

# RSqNB --------------------------------------------------------------------
out <- RSqNB(nb, alpha = 0.05)

## Methods -----------------------------------------------------------------
print(out)
summary(out)
coef(out)
vcov(out)
confint(out, level = 0.95)

}
\seealso{
Other Beta Nonparametric Bootstrap Functions: 
\code{\link{BetaNB}()},
\code{\link{DeltaRSqNB}()},
\code{\link{DiffBetaNB}()},
\code{\link{NB}()},
\code{\link{PCorNB}()},
\code{\link{SCorNB}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Nonparametric Bootstrap Functions}
\keyword{betaNB}
\keyword{rsq}
