% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaSandwich-beta-adf.R
\name{BetaADF}
\alias{BetaADF}
\title{Estimate Standardized Regression Coefficients
and Sampling Covariance Matrix
Using the Asymptotic Distribution-Free Approach}
\usage{
BetaADF(object)
}
\arguments{
\item{object}{Object of class \code{lm}.}
}
\value{
Returns an object of class \code{betaSandwich}
which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{type}{Standard error type.}
\item{beta}{Vector of standardized slopes.}
\item{vcov}{Sampling covariance matrix of the standardized slopes.}
\item{n}{Sample size.}
\item{p}{Number of regressors.}
\item{df}{\eqn{n - p - 1} degrees of freedom}
}
}
\description{
Estimate Standardized Regression Coefficients
and Sampling Covariance Matrix
Using the Asymptotic Distribution-Free Approach
}
\details{
\code{BetaADF()} is appropriate when sample sizes are moderate to large
(\code{n > 250}).
\code{BetaHC()} is recommended in most situations.
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaADF(object)
# Methods -------------------------------------------------------
print(std)
summary(std)
coef(std)
vcov(std)
confint(std, level = 0.95)
}
\seealso{
Other Beta Sandwich Functions: 
\code{\link{BetaHC}()},
\code{\link{BetaN}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Sandwich Functions}
\keyword{betaSandwich}
