% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissimilarityIndicesFunctions.R
\name{getDissimilarityEstimates}
\alias{getDissimilarityEstimates}
\title{Estimate Dissimilarity Indices}
\usage{
getDissimilarityEstimates(
  dataset,
  plotIdField,
  speciesIdField,
  populationSize,
  memSize = NULL
)
}
\arguments{
\item{dataset}{a data.frame object that contains at least two fields: one for the sample plot ids and the other
for the species. Each row is actually an observation of a species in a particular plot.}

\item{plotIdField}{the name of the field that contains the sample plot id in the dataset.}

\item{speciesIdField}{the name of the field that contains the species in the dataset.}

\item{populationSize}{the number of units in the population. That is the total number of sample plots that
could fit in the population. Under the assumption that the plot size is constant, the population size is calculated
as the area of the population divided by the area of a single sample plot.}

\item{memSize}{the size of the Java Virtual Machine in Mg (if not specified the JVM is instantiated with the default memory size, which depends on the available RAM)}
}
\value{
a data.frame object with the estimated dissimilarity indices and their standard errors
}
\description{
This function computes estimates of the adapted dissimilarity indices of Simpson, Sorensen and
nestedness from a sample.
}
\details{
The dissimilarity indices were adapted from those of Baselga (2010). These adapted indices are population size independent
so that it is possible to compare the dissimilarity of two populations of unequal sizes.

This function implements estimators of these adapted indices. A sample of plots with species observations must be passed to the function
as well as the population size, that is the number of plots that fit in this population. The variance estimation is based on the Jackknife
method. The function returns a data.frame object with the estimates of the multiple-site version of Simpson, Sorensen and nestedness as well
as their associated standard errors. In addition, the function also provides an estimate of the alpha and gamma diversity. The
gamma diversity estimate is based on the Chao2 estimator (Chao and Lin 2012).
}
\examples{

### An example using the subsetUrbanEnvironmentNancy dataset ###
\dontrun{
dataReleves <- betadiv::subsetUrbanEnvironmentNancy

strataList <- unique(dataReleves$Stratum)
output <- NULL
baselga <- NULL
stratum <- strataList[1]

for (stratum in strataList) {
  releve.s <- dataReleves[which(dataReleves$Stratum == stratum),]
  if (stratum == "forest") {
    populationSize <- 3089 * 10000 / (pi * 5^2)
  } else if (stratum == "parking") {
    populationSize <- 501 * 10000 / (pi * 5^2)
  } else {
    populationSize <- 100000
  }

  indices <- getDissimilarityEstimates(releve.s, "CODE_POINT", "Espece",
                                         populationSize, memSize = 500)
  indices$stratum <- stratum
  output <- rbind(output, indices)
}
}
}
\references{
Fortin, M., A. Kondratyeva, and R. Van Couwenberghe. 2020. Improved Beta-diversity estimators
based on multiple-site dissimilarity: Distinguishing the sample from the population. Global Ecology and
Biogeography 29: 1073-1084. \url{https://doi.org/10.1111/geb.13080}

Baselga, A. 2010. Partitioning the turnover and nestedness components of beta diversity.
Global Ecology and Biogeography 19:134-143.

Chao A., and C.-W Lin. 2012. Nonparametric lower bounds for species richness and shared species richness
under sampling without replacement. Biometrics 68: 912-921.
}
