% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{AMS}
\alias{AMS}
\title{Alpha Shape Parameter Given Mean and Variance of a Standard Beta PDD.}
\usage{
AMS(mean, var, sd = NULL)
}
\arguments{
\item{mean}{The mean of the target Standard Beta probability density distribution.}

\item{var}{The variance of the target Standard Beta probability density distribution.}

\item{sd}{The standard deviation of the target Standard Beta probability density distribution.}
}
\value{
A numeric value representing the required value for the Alpha shape-parameter in order to produce a Standard Beta probability density distribution with the target mean and variance.
}
\description{
Calculates the Alpha value required to produce a Standard  (two-parameter) Beta probability density distribution with defined mean and variance or standard deviation.
}
\examples{
# Generate some fictional data. Say, 100 individuals take a test with a
# maximum score of 100 and a minimum score of 0, rescaled to proportion
# of maximum.
set.seed(1234)
testdata <- rbinom(100, 100, rBeta.4P(100, .25, .75, 5, 3)) / 100
hist(testdata, xlim = c(0, 100))

# To find the alpha shape-parameter of a Standard (two-parameter) Beta
# distribution with the same mean and variance as the observed-score
# distribution using \\code{AMS()}:
AMS(mean(testdata), var(testdata))
}
