% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m2bgumbel.R
\name{m2bgumbel}
\alias{m2bgumbel}
\title{Bimodal Gumbel: Theoretical E(X^2)}
\usage{
m2bgumbel(mu, sigma, delta)
}
\arguments{
\item{mu}{First location parameter.}

\item{sigma}{Scale parameter.}

\item{delta}{Second location parameter.}
}
\value{
Vector.
}
\description{
Bimodal Gumbel: Theoretical E(X^2)
}
\examples{
(EX2 <- m2bgumbel(mu = -2, sigma = 1, delta = -1))

\donttest{
# Comparison: Theoretical E(X^2) and empirical second moment

x <- rbgumbel(100000, mu = -2, sigma = 1, delta = -1)
mean(x^2)
abs(EX2 - mean(x))/abs(EX2) # relative error

# Variance
EX <- m1bgumbel(mu = -2, sigma = 1, delta = -1)
EX2 - EX^2
var(x)
abs(EX2 - EX^2 - var(x))/abs(EX2 - EX^2) # relative error

# grid 1

mu <- seq(-5, 5, length.out = 100)
delta <- seq(-5, 5, length.out = 100)
z <- outer(
  X <- mu,
  Y <- delta,
  FUN = function(x, y) m2bgumbel(mu = x, sigma = 1, delta = y)
)
persp(x = mu, y = delta, z = z, theta = -30, ticktype = 'detailed')

# grid 2

mu <- seq(-5, 5, length.out = 100)
delta <- seq(-5, 5, length.out = 100)
sigmas <- seq(.1, 10, length.out = 20)
for (sigma in sigmas) {
  z <- outer(
    X <- mu,
    Y <- delta,
    FUN = function(x, y) m2bgumbel(mu = x, sigma = sigma, delta = y)
  )
  persp(x = mu, y = delta, z = z, theta = -45, zlab = 'E(X^2)')
  Sys.sleep(.5)
}
}
}
