% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataFunctions.R
\name{simulateScenarios}
\alias{simulateScenarios}
\title{simulateScenarios}
\usage{
simulateScenarios(
  n_subjects_list,
  response_rates_list,
  scenario_numbers = seq_along(n_subjects_list),
  n_trials = 10000
)
}
\arguments{
\item{n_subjects_list}{A list that contains for each scenario a vector for
the number of subjects per cohort}

\item{response_rates_list}{A list that contains for each scenario a vector for
the response rates per cohort}

\item{scenario_numbers}{A vector of positive integers naming the scenarios,
Default: \code{seq_along(n_subjects_list)}}

\item{n_trials}{An integer indicating the number of trial simulations per response rates,
Default: \code{10000}}
}
\value{
An object of class \code{scenario_list} with the scenario data for each specified scenario.
}
\description{
This function creates scenarios for the analysis with
\code{\link[bhmbasket]{performAnalyses}}.
}
\details{
The function simulates trials with binary outcome for each scenario.
Integer values for the response rates will be treated as observed outcomes.
}
\examples{
  n_subjects     <- c(10, 20, 30)

  rr_negative    <- rep(0.1, 3)
  rr_nugget      <- c(0.9, 0.1, 0.1)
  rr_positive    <- rep(0.9, 3)

  scenarios_list <- simulateScenarios(
    n_subjects_list     = list(n_subjects,
                               n_subjects,
                               n_subjects),
    response_rates_list = list(rr_negative,
                               rr_nugget,
                               rr_positive))
}
\seealso{
\code{\link[bhmbasket]{saveScenarios}}
\code{\link[bhmbasket]{createTrial}}
\code{\link[bhmbasket]{performAnalyses}}
}
\author{
Stephan Wojciekowski
}
