% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2df.R
\name{convert2df}
\alias{convert2df}
\title{Convert an ISI or SCOPUS Export file into a data frame}
\usage{
convert2df(file, dbsource = "isi", format = "bibtex")
}
\arguments{
\item{file}{is a character array containing data read from an ISI WoK Export file (in plain text or bibtex format) or SCOPUS Export file (exclusively in bibtex format).}

\item{dbsource}{is a character indicating the bibliographic database. \code{dbsource} can be \code{"isi"} or \code{"scopus"}. Default is \code{dbsource = "isi"}.}

\item{format}{is a character indicating the format of the SCOPUS and Thomson Reuters' ISI Web of Knowledge export file. \code{format} can be \code{"bibtex"} or \code{"plaintext"}. Default is \code{format = "bibtex"}.}
}
\value{
a data frame with cases corresponding to articles and variables to Field Tag in the original export file.

data frame columns are named using the standard ISI WoS Field Tag codify. The main field tags are:

\tabular{lll}{
\code{AU}\tab   \tab Authors\cr
\code{TI}\tab   \tab Document Title\cr
\code{SO}\tab   \tab Publication Name (or Source)\cr
\code{JI}\tab   \tab ISO Source Abbreviation\cr
\code{DT}\tab   \tab Document Type\cr
\code{DE}\tab   \tab Authors' Keywords\cr
\code{ID}\tab   \tab Keywords associated by SCOPUS or ISI database \cr
\code{AB}\tab   \tab Abstract\cr
\code{C1}\tab   \tab Author Address\cr
\code{RP}\tab   \tab Reprint Address\cr
\code{CR}\tab   \tab Cited References\cr
\code{TC}\tab   \tab Times Cited\cr
\code{PY}\tab   \tab Year\cr
\code{SC}\tab   \tab Subject Category\cr
\code{UT}\tab   \tab Unique Article Identifier\cr
\code{DB}\tab   \tab Database\cr}

for a complete list of filed tags see: \href{https://images.webofknowledge.com/WOK46/help/WOS/h_fieldtags.html}{ISI WoS Field Tags}
}
\description{
It converts a SCOPUS and Thomson Reuters' ISI Web of Knowledge export file and create a data frame from it, with cases corresponding to articles and variables to Field Tag in the original file.
}
\details{
Actually the function allows to convert both SCOPUS/ISI files in bibtext format and just ISI files in plain text format.
}
\examples{
# An ISI or SCOPUS Export file can be read using \\code{\\link{readLines}} function:

# largechar <- readLines('filename.txt')

# filename.txt is an ISI or SCOPUS Export file in plain text or bibtex format.
# The file have to be saved without Byte order mark (U+FEFF) at the beginning
# and EoF code at the end of file.
# The original file (exported by ISI or SCOPUS search web site) can be modified
# using an advanced text editor like Notepad++ or Emacs.

#  biblio <- readLines('http://www.bibliometrix.org/datasets/bibliometrics_articles.txt')

data(biblio)

biblio_df_df <- convert2df(file = biblio, dbsource = "isi", format = "bibtex")

}
\seealso{
\code{\link{scopus2df}} for converting SCOPUS Export file (in bibtex format)

\code{\link{isibib2df}} for converting ISI Export file (in bibtex format)

\code{\link{isi2df}} for converting ISI Export file (in plain text format)

Other converting.functions: \code{\link{isi2df}},
  \code{\link{isibib2df}}, \code{\link{scopus2df}}
}

