% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bid_structure.R
\name{bid_structure}
\alias{bid_structure}
\title{Document Dashboard Structure Stage in BID Framework}
\usage{
bid_structure(previous_stage, concepts = NULL, ...)
}
\arguments{
\item{previous_stage}{A tibble or list output from an earlier BID stage
function.}

\item{concepts}{A character vector of additional BID concepts to include.
Concepts can be provided in natural language (e.g., "Principle of
Proximity") or with underscores (e.g., "principle_of_proximity"). The
function uses fuzzy matching to identify the concepts. If NULL, will
detect relevant concepts from previous stages automatically.}

\item{...}{Additional parameters. If \code{layout} is provided via \code{...}, the
function will abort with a helpful error message.}
}
\value{
A bid_stage object containing:
\item{stage}{"Structure"}
\item{layout}{Auto-selected layout type}
\item{suggestions}{List of concept groups with ranked suggestions}
\item{concepts}{Comma-separated string of all concepts used}
}
\description{
This function documents the structure of the dashboard with automatic layout
selection and generates ranked, concept-grouped actionable UI/UX suggestions.
Layout is intelligently chosen based on content analysis of previous stages
using deterministic heuristics. Returns structured recommendations with
specific component pointers and implementation rationales.
}
\details{
\strong{Layout Auto-Selection}: Uses deterministic heuristics to analyze content
from previous stages and select the most appropriate layout:
\itemize{
\item \strong{breathable}: For information overload/confusion patterns
\item \strong{dual_process}: For overview vs detail needs
\item \strong{grid}: For grouping/comparison requirements
\item \strong{card}: For modular/chunked content
\item \strong{tabs}: For categorical organization (unless telemetry shows issues)
}

\strong{Suggestion Engine}: Generates ranked, actionable recommendations grouped
by UX concepts. Each suggestion includes specific Shiny/bslib components,
implementation details, and rationale. Suggestions are scored based on
relevance, layout appropriateness, and contextual factors.
}
\examples{
interpret <- bid_notice(
  problem = "Users struggle with information overload",
  evidence = "Survey results indicate delays"
) |>
  bid_interpret(
    central_question = "How can we simplify data presentation?",
    data_story = list(
      hook = "Data is too complex",
      context = "Overloaded with charts",
      tension = "Confusing layout",
      resolution = "Introduce clear grouping"
    )
  )

# Auto-selected layout with concept-grouped suggestions
structure_result <- bid_structure(previous_stage = interpret)
print(structure_result$layout)  # Auto-selected layout
print(structure_result$suggestions)  # Ranked suggestions by concept

}
