% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_within_params.R
\name{estimate_within_params}
\alias{estimate_within_params}
\title{Estimate a within-block network model.}
\usage{
estimate_within_params(
  formula,
  network,
  z_memb,
  number_cores = 1,
  verbose = 1,
  seeds = NULL,
  method_second_step = c("MPLE", "MLE"),
  offset_coef = NULL,
  ...
)
}
\arguments{
\item{formula}{a within network formula}

\item{network}{a network object}

\item{z_memb}{block memberships for each node}

\item{number_cores}{The number of CPU cores to use.}

\item{verbose}{A logical or an integer: if this is TRUE/1,
the program will print out additional information about the progress of estimation and simulation.}

\item{seeds}{seed value (integer) for the random number generator}

\item{method_second_step}{If "MPLE" (the default), then the maximum pseudolikelihood estimator is returned.
If "MLE", then an approximate maximum likelihood estimator is returned.}

\item{offset_coef}{a vector of model parameters to be fixed when estimation.(i.e., not estimated).}

\item{...}{Additional arguments, to be passed to lower-level functions}
}
\value{
'ergm' object of the estimated model.
}
\description{
Estimate a within-block network model.
}
\examples{
adj <- c(
c(0, 1, 0, 0, 1, 0),
c(1, 0, 1, 0, 0, 1),
c(0, 1, 0, 1, 1, 0),
c(0, 0, 1, 0, 1, 1),
c(1, 0, 1, 1, 0, 1),
c(0, 1, 0, 1, 1, 0)
)
adj <- matrix(data = adj, nrow = 6, ncol = 6)
rownames(adj) <- as.character(1001:1006)
colnames(adj) <- as.character(1001:1006)

# Use non-consecutive block names
block <- c(50, 70, 95, 50, 95, 70)

g <- network::network(adj, matrix.type = "adjacency")

est <- estimate_within_params(
  formula = g ~ edges,
  network = g,
  z_memb = block,
  parallel = FALSE,
  verbose = 0,
  initial_estimate = NULL,
  seeds = NULL,
  method_second_step = "MPLE"
)
}
