% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_correction.r
\name{stability.correction}
\alias{stability.correction}
\title{Integrated Stability Correction Functions for Heat and Momentum}
\usage{
stability.correction(zeta, formulation = c("Dyer_1970", "Businger_1971"))
}
\arguments{
\item{zeta}{Stability parameter zeta (-)}

\item{formulation}{Formulation for the stability function. Either \code{"Dyer_1970"}, 
or \code{"Businger_1971"}}
}
\value{
a data.frame with the following columns:
         \item{psi_h}{the value of the stability function for heat and water vapor (-)}
         \item{psi_m}{the value of the stability function for momentum (-)}
}
\description{
dimensionless stability functions needed to correct deviations
             from the exponential wind profile under non-neutral conditions.
}
\details{
The functions give the integrated form of the universal functions. They
         depend on the value of the stability parameter \eqn{\zeta},
         which can be calculated from the function \code{\link{stability.parameter}}.
         The integration of the universal functions is:
         
           \deqn{\psi = -x * zeta} 
         
         for stable atmospheric conditions (\eqn{\zeta} >= 0), and
         
           \deqn{\psi = 2 * log( (1 + y) / 2) }
         
         for unstable atmospheric conditions (\eqn{\zeta} < 0).
         
         The different formulations differ in their value of x and y.
}
\examples{
zeta <- seq(-2,0.5,0.05)
stability.correction(zeta)
stability.correction(zeta,formulation="Businger_1971")                          
            
}
\references{
Dyer, A.J., 1974: A review of flux-profile relationships. 
            Boundary-Layer Meteorology 7, 363-372.
            
            Dyer, A. J., Hicks, B.B., 1970: Flux-Gradient relationships in the
            constant flux layer. Quart. J. R. Meteorol. Soc. 96, 715-721.
            
            Businger, J.A., Wyngaard, J. C., Izumi, I., Bradley, E. F., 1971:
            Flux-Profile relationships in the atmospheric surface layer. 
            J. Atmospheric Sci. 28, 181-189.
            
            Paulson, C.A., 1970: The mathematical representation of wind speed
            and temperature profiles in the unstable atmospheric surface layer.
            Journal of Applied Meteorology 9, 857-861.

            Foken, T, 2008: Micrometeorology. Springer, Berlin, Germany.
}
