% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vctrs-math.R
\name{bignum-special}
\alias{bignum-special}
\title{Check for special values}
\value{
A logical vector.
}
\description{
\link{biginteger} and \link{bigfloat} support missing values (via \code{NA_biginteger_} and
\code{NA_bigfloat_} respectively).

\link{bigfloat} additionally supports positive and negative infinity and
'Not a Number' values. Usually these are the result of a calculation, but
they can also be created manually by casting from \link{numeric} to \link{bigfloat}.

These functions check for the presence of these special values. The base R
documentation can be found at \code{\link[=is.na]{is.na()}} and \code{\link[=is.finite]{is.finite()}}.
}
\examples{
x <- bigfloat(c(0, NA, Inf, -Inf, NaN))

is.na(x)
is.finite(x)
is.infinite(x)
is.nan(x)
}
\seealso{
Other bignum operations: 
\code{\link{bignum-arith}},
\code{\link{bignum-compare}},
\code{\link{bignum-math}}
}
\concept{bignum operations}
