% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bq-auth.R
\name{bq_auth_configure}
\alias{bq_auth_configure}
\alias{bq_oauth_client}
\title{Edit and view auth configuration}
\usage{
bq_auth_configure(client, path, app = deprecated())

bq_oauth_client()
}
\arguments{
\item{client}{A Google OAuth client, presumably constructed via
\code{\link[gargle:gargle_oauth_client_from_json]{gargle::gargle_oauth_client_from_json()}}. Note, however, that it is
preferred to specify the client with JSON, using the \code{path} argument.}

\item{path}{JSON downloaded from \href{https://console.cloud.google.com}{Google Cloud Console}, containing a client id and
secret, in one of the forms supported for the \code{txt} argument of
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a file path or JSON string).}

\item{app}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Replaced by the \code{client}
argument.}
}
\value{
\itemize{
\item \code{bq_auth_configure()}: An object of R6 class
\link[gargle:AuthState-class]{gargle::AuthState}, invisibly.
\item \code{bq_oauth_client()}: the current user-configured OAuth client.
}
}
\description{
These functions give more control over and visibility into the auth
configuration than \code{\link[=bq_auth]{bq_auth()}} does. \code{bq_auth_configure()}
lets the user specify their own:
\itemize{
\item OAuth client, which is used when obtaining a user token.
}

See the \code{vignette("get-api-credentials", package = "gargle")}
for more.
If the user does not configure these settings, internal defaults
are used.

\code{bq_oauth_client()} retrieves the currently configured OAuth client.
}
\examples{
# see and store the current user-configured OAuth client (probably `NULL`)
(original_client <- bq_oauth_client())

# the preferred way to configure your own client is via a JSON file
# downloaded from Google Developers Console
# this example JSON is indicative, but fake
path_to_json <- system.file(
  "extdata", "data", "client_secret_123.googleusercontent.com.json",
  package = "bigrquery"
)
bq_auth_configure(path = path_to_json)

# confirm the changes
bq_oauth_client()

# restore original auth config
bq_auth_configure(client = original_client)
}
\seealso{
Other auth functions: 
\code{\link{bq_auth}()},
\code{\link{bq_deauth}()}
}
\concept{auth functions}
