% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldsc.R
\name{snp_ldsc}
\alias{snp_ldsc}
\alias{snp_ldsc2}
\title{LD score regression}
\usage{
snp_ldsc(
  ld_score,
  ld_size,
  chi2,
  sample_size,
  blocks = 200,
  intercept = NULL,
  chi2_thr1 = 30,
  chi2_thr2 = Inf,
  ncores = 1
)

snp_ldsc2(corr, df_beta, blocks = NULL, intercept = 1, ncores = 1, ...)
}
\arguments{
\item{ld_score}{Vector of LD scores.}

\item{ld_size}{Number of variants used to compute \code{ld_score}.}

\item{chi2}{Vector of chi-squared statistics.}

\item{sample_size}{Sample size of GWAS corresponding to chi-squared statistics.
Possibly a vector, or just a single value.}

\item{blocks}{Either a single number specifying the number of blocks,
or a vector of integers specifying the block number of each \code{chi2} value.
Default is \code{200} for \code{snp_ldsc()}, dividing into 200 blocks of approximately
equal size. \code{NULL} can also be used to skip estimating standard errors,
which is the default for \code{snp_ldsc2()}.}

\item{intercept}{You can constrain the intercept to some value (e.g. 1).
Default is \code{NULL} in \code{snp_ldsc()} (the intercept is estimated)
and is \code{1} in \code{snp_ldsc2()} (the intercept is fixed to 1).
This is equivalent to parameter \code{--intercept-h2}.}

\item{chi2_thr1}{Threshold on \code{chi2} in step 1. Default is \code{30}.
This is equivalent to parameter \code{--two-step}.}

\item{chi2_thr2}{Threshold on \code{chi2} in step 2. Default is \code{Inf} (none).}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{corr}{Sparse correlation matrix. Can also be an \link[=SFBM-class]{SFBM}.}

\item{df_beta}{A data frame with 3 columns:
\itemize{
\item \verb{$beta}: effect size estimates
\item \verb{$beta_se}: standard errors of effect size estimates
\item \verb{$n_eff}: sample size when estimating \code{beta}
(in the case of binary traits, this is \code{4 / (1 / n_control + 1 / n_case)})
}}

\item{...}{
  Arguments passed on to \code{\link[=snp_ldsc]{snp_ldsc}}
  \describe{
    \item{\code{}}{}
  }}
}
\value{
Vector of 4 values (or only the first 2 if \code{blocks = NULL}):
\itemize{
\item \verb{[["int"]]}: LDSC regression intercept,
\item \verb{[["int_se"]]}: SE of this intercept,
\item \verb{[["h2"]]}: LDSC regression estimate of (SNP) heritability (also see
\link{coef_to_liab}),
\item \verb{[["h2_se"]]}: SE of this heritability estimate.
}
}
\description{
LD score regression
}
\examples{
bigsnp <- snp_attachExtdata()
G <- bigsnp$genotypes
y <- bigsnp$fam$affection - 1
corr <- snp_cor(G, ind.col = 1:1000)

gwas <- big_univLogReg(G, y, ind.col = 1:1000)
df_beta <- data.frame(beta = gwas$estim, beta_se = gwas$std.err,
                      n_eff = 4 / (1 / sum(y == 0) + 1 / sum(y == 1)))

snp_ldsc2(corr, df_beta)
snp_ldsc2(corr, df_beta, blocks = 20, intercept = NULL)

}
