% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colstats.R
\name{big_colstats}
\alias{big_colstats}
\title{Standard univariate statistics}
\usage{
big_colstats(X, ind.row = rows_along(X), ind.col = cols_along(X))
}
\arguments{
\item{X}{A \link[=FBM-class]{FBM}.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}
}
\value{
Data.frame of two numeric vectors \code{sum} and \code{var} with the
corresponding column statistics.
}
\description{
Standard \strong{univariate statistics} for columns of a Filebacked Big Matrix.
For now, the \code{sum} and \code{var} are implemented
(the \code{mean} and \code{sd} can easily be deduced, see examples).
}
\examples{
set.seed(1)

X <- big_attachExtdata()

# Check the results
str(test <- big_colstats(X))

# Only with the first 100 rows
ind <- 1:100
str(test2 <- big_colstats(X, ind.row = ind))
plot(test$sum, test2$sum)
abline(lm(test2$sum ~ test$sum), col = "red", lwd = 2)

X.ind <- X[ind, ]
all.equal(test2$sum, colSums(X.ind))
all.equal(test2$var, apply(X.ind, 2, var))

# deduce mean and sd
# note that the are also implemented in big_scale()
means <- test2$sum / length(ind) # if using all rows,
                                 # divide by nrow(X) instead
all.equal(means, colMeans(X.ind))
sds <- sqrt(test2$var)
all.equal(sds, apply(X.ind, 2, sd))
}
\seealso{
\link{colSums} \link{apply}
}
