% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doSingleTests.R
\name{doSingleTests}
\alias{doSingleTests}
\title{Single tests}
\usage{
doSingleTests(X, y, maxp = 1e+07, verbose = TRUE)
}
\arguments{
\item{X}{a numeric matrix or an object of class big.matrix (see 'Details').
The rows of \code{X} contain the samples, the columns of \code{X} contain
the observed variables.}

\item{y}{a numeric vector of responses. The length of \code{y} must equal
the number of rows of \code{X}.}

\item{maxp}{a numeric. If \code{X} is big, it will be splitted into parts
with \code{maxp} elements. It will not change results, but it is
necessary if your computer does not have enough RAM. Set to a lower value
if you still have problems.}

\item{verbose}{a logical. Set \code{FALSE} if you do not want to see any
information during the selection procedure.}
}
\value{
A list with the following components:
\item{r}{a numeric vector with the Pearson correlation coefficients}
\item{t}{a numeric vector with t-values}
\item{pv}{a numeric vector with p-values}
}
\description{
Peform correlation tests between a vector y and a matrix X.
}
\examples{
set.seed(1)
n <- 100
M <- 10
X <- matrix(rnorm(M*n), ncol=M)
y <- X[, 2] - X[, 3] + X[, 6] - X[, 10] + rnorm(n, sd=1)
doSingleTests(X, y)

}

