% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singleTests.R
\name{singleTests}
\alias{singleTests}
\title{Single tests}
\usage{
singleTests(X, y, fitFun = fitLinear, maxp = 1e+06, verbose = TRUE)
}
\arguments{
\item{X}{a numeric matrix or an object of class big.matrix (see 'Details').
The rows of \code{X} contain the samples, the columns of \code{X} contain
the observed variables. If your have variables in rows, see 'Details'.}

\item{y}{a numeric vector of responses. The length of \code{y} must equal
the number of rows of \code{X}.}

\item{fitFun}{a function which fits the regression model and calculate
the logarithm of the likelihood function (loglike). You can use your own
function or one of these: \code{fitLinear}, \code{fitLogistic},
\code{fitPoisson}.}

\item{maxp}{a numeric. If \code{X} is big, it will be splitted into parts
with \code{maxp} elements. It will not change results, but it is
necessary if your computer does not have enough RAM. Set to a lower value
if you still have problems.}

\item{verbose}{a logical. Set \code{FALSE} if you do not want to see any
information during the selection procedure.}
}
\value{
A numeric vector with p-values of the likelihood ratio test.
}
\description{
Perform the likelihood ratio tests between two regression models: 1) with
only the intercept, 2) with the intercept and every single variable
from the matrix \code{X}.
}
\examples{
set.seed(1)
n <- 100
M <- 10
X <- matrix(rnorm(M*n), ncol=M)
y <- X[, 2] - X[, 3] + X[, 6] - X[, 10] + rnorm(n)
singleTests(X, y)

}

