% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdpca.R
\name{pca_adjust}
\alias{pca_adjust}
\title{Adjusting shrinkage in PC scores}
\usage{
pca_adjust(test.scores, train.eval, p, n = length(train.eval),
  method = c("d.gsp", "l.gsp", "osp"),
  n.spikes = pca_nspike(train.eval))
}
\arguments{
\item{test.scores}{
An \eqn{m\times k} matrix or data frame containing the first \eqn{k} predicted PC scores of \eqn{m} many test samples.
}

\item{train.eval}{
Numeric vector containing the sample eigenvalues. The vector must have dimension \code{n} or \code{n-1}, it may be unordered.
}

\item{p}{
The number of features.
}

\item{n}{
The number of training samples.
}

\item{method}{
String specifying the estimation method. Possible values are "\code{d.gsp}" (default),"\code{l.gsp}" and "\code{osp}".
}

\item{n.spikes}{
Number of distant spikes in the population (Optional).
}
}
\value{
A matrix containing the bias-adjusted PC scores.
The dimension of the matrix is the same as the dimension of \code{test.scores}.

Also, an attribute \code{attr(*, "shrinkage")} containing the shrinkage factors.
Note that the number of shrinkage factors can be smaller than the number of
columns of \code{test.scores}; it corresponds to the estimated number of spikes.
}
\description{
Adjusts the shrinkage bias in the predicted PC scores based on the estimated shrinkage factors.
}
\details{
The different choices for \code{method} are:
\itemize{
\item "\code{d.gsp}": \eqn{d}-estimation method based on the Generalized Spiked Population (GSP) model.
\item "\code{l.gsp}": \eqn{\lambda}-estimation method based on the GSP model.
\item "\code{osp}": Estimation method based on the Ordinary Spiked Population (OSP) model.
}
The \eqn{(i,j)^{th}} element of \code{test.scores} should denote the \eqn{j^{th}} predicted PC score for the \eqn{i^{th}} subject in the test sample.

At least one of \code{n.spikes} and \code{n.spikes.max} must be provided. If \code{n.spikes} is provided then \code{n.spikes.max} is ignored, else \code{n.spikes.max} is used to find out the number of distant spikes using \code{\link{select.nspike}}.

The argument \code{nonspikes.out} is ignored if \code{method="d.gsp"} or "\code{osp}".

The argument \code{smooth} is useful when the user assumes the population spectral distribution to be continuous.
}
\examples{
X <- readRDS(system.file("testdata", "three-pops.rds", package = "bigutilsr"))
N <- 400; M <- ncol(X)
ind <- sample(nrow(X), N)
# Compute SVD using one part of samples
svd <- svd(X[ind, ])
U <- sweep(svd$u, 2, svd$d, '*')
plot(U[, 2:3])
# Projecting other samples
U1 <- X[-ind, ] \%*\% svd$v
points(U1[, 2:3], col = "red", pch = 20)               # shrunk towards 0
U2 <- pca_adjust(U1, svd$d^2, M, N)
points(U2[, 2:3], col = "blue", pch = 20)              # unshrunk
attr(U2, "shrinkage")

}
\references{
Dey, R. and Lee, S. (2019).
\emph{Asymptotic properties of principal component analysis and shrinkage-bias adjustment under the generalized spiked population model.}
Journal of Multivariate Analysis, Vol 173, 145-164.
}
\seealso{
\code{\link[hdpca:pc_adjust]{hdpca::pc_adjust()}}
}
