% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store-bikedata.R
\name{index_bikedata_db}
\alias{index_bikedata_db}
\title{Add indexes to database created with store_bikedata}
\usage{
index_bikedata_db(bikedb)
}
\arguments{
\item{bikedb}{The SQLite3 database containing the bikedata.}
}
\description{
Add indexes to database created with store_bikedata
}
\examples{
\dontrun{
data_dir <- tempdir ()
bike_write_test_data (data_dir = data_dir)
# or download some real data!
# dl_bikedata (city = 'la', data_dir = data_dir)
bikedb <- file.path (data_dir, 'testdb')
store_bikedata (data_dir = data_dir, bikedb = bikedb)
# create database indexes for quicker access:
index_bikedata_db (bikedb = bikedb)

trips <- bike_tripmat (bikedb = bikedb, city = 'LA') # trip matrix
stations <- bike_stations (bikedb = bikedb) # station data

bike_rm_test_data (data_dir = data_dir)
bike_rm_db (bikedb)
# don't forget to remove real data!
# file.remove (list.files (data_dir, pattern = '.zip'))
}
}
