% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_utils.R
\name{bb_bubble}
\alias{bb_bubble}
\title{Bubble property for a Billboard.js chart}
\usage{
bb_bubble(bb, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{...}{See \url{https://naver.github.io/billboard.js/release/latest/doc/Options.html#.bubble}}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Bubble property for a Billboard.js chart
}
\examples{
billboarder() \%>\% 
  bb_scatterplot(
    data = iris, 
    mapping = bbaes(Sepal.Length, Sepal.Width, group = Species, size = Petal.Width)
  ) \%>\% 
  bb_bubble(maxR = 10)


billboarder() \%>\% 
  bb_scatterplot(
    data = iris, 
    mapping = bbaes(Sepal.Length, Sepal.Width, group = Species, size = Petal.Width)
  ) \%>\% 
  bb_bubble(maxR = JS("function(d) {return Math.sqrt(d.value.z * 20);}"))
}
