% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_helpers.R
\name{bb_gaugechart}
\alias{bb_gaugechart}
\title{Helper for creating a gauge}
\usage{
bb_gaugechart(
  bb,
  value,
  name = "Value",
  steps = c(30, 60, 90, 100),
  steps_color = c("#FF0000", "#F97600", "#F6C600", "#60B044"),
  ...
)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{value}{A numeric value.}

\item{name}{Name for the value, appear in  tooltip.}

\item{steps}{Upper bound for changing colors}

\item{steps_color}{Colors corresponding to steps}

\item{...}{Arguments for slot gauge.}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Helper for creating a gauge
}
\note{
This function can be used with \code{\link{billboarderProxy}} in shiny application.
}
\examples{
billboarder() \%>\% 
  bb_gaugechart(value = 50)

# With some options
billboarder() \%>\% 
  bb_gaugechart(
    value = 160,
    steps_color = rev(c("#FF0000", "#F97600", "#F6C600", "#60B044"))
  ) \%>\% 
  bb_gauge(
    label = list(format = suffix("km/h")),
    min = 10, max = 200, width = 20
  )

}
