% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NI.D3.R
\name{NI.D3}
\alias{NI.D3}
\title{Non-informative three-stage hierarchical testing}
\usage{
NI.D3(p, Se, Sp, group.sz, obj.fn, weights)
}
\arguments{
\item{p}{the probability of disease, which can be specified as an overall
probability of disease or a homogeneous vector of individual probabilities}

\item{Se}{the sensitivity of the diagnostic test}

\item{Sp}{the specificity of the diagnostic test}

\item{group.sz}{a single group size over which to find the optimal testing
configuration out of all possible testing configurations, or a range of
group sizes over which to find the optimal testing configuration}

\item{obj.fn}{a list of objective functions which are minimized to find the
optimal testing configuration. Available options include "\kbd{ET}" (the expected
number of tests per individual), "\kbd{MAR}" (the expected number of tests divided
by the expected number of correct classifications, described in Malinovsky et al. (2016)),
\url{http://www.chrisbilder.com/grouptesting/HBTM/} for additional details.}

\item{weights}{a matrix of up to six sets of weights for the GR function. Each set of
weights is specified by a row of the matrix.}
}
\value{
A list containing:
\item{prob}{the probability of disease, as specified by the user}
\item{Se}{the sensitivity of the diagnostic test}
\item{Sp}{the specificity of the diagnostic test}
\item{opt.ET, opt.MAR, opt.GR}{a list for each objective function specified by the
user, containing:
\describe{
\item{OTC}{a list specifying the optimal testing configuration, which includes:
\describe{
\item{Stage1}{the pool size for the first stage of testing, i.e. the initial
group size}
\item{Stage2}{pool sizes for the second stage of testing}}}
\item{p.vec}{the vector of individual probabilities}
\item{ET}{the expected testing expenditure for the OTC}
\item{value}{the value of the objective function per individual}
\item{PSe}{the overall pooling sensitivity for the algorithm}
\item{PSp}{the overall pooling specificity for the algorithm}
\item{PPPV}{the overall pooling positive predictive value for the algorithm}
\item{PNPV}{the overall pooling negative predictive value for the algorithm}}}
}
\description{
Find the optimal testing configuration for
non-informative three-stage hierarchical testing and calculate
the associated operating characteristics.
}
\details{
This function finds the optimal testing configuration
and computes the associated operating characteristics for non-informative
three-stage hierarchical testing. This function finds the optimal testing
configuration by considering all possible configurations. See Hitt et al.
(2018) at \url{http://www.chrisbilder.com/grouptesting/HBTM/} or Kim et al.
(2007) for additional details.
}
\examples{
# Find the optimal testing configuration for non-informative three-stage
#   hierarchical testing over a range of group sizes
\dontrun{
NI.D3(p=0.02, Se=0.90, Sp=0.90, group.sz=3:20, obj.fn=c("ET", "MAR"),
weights=NULL)
}

# Find the optimal testing configuration out of all possible
#   configurations for a specified group size for non-informative
#   three-stage hierarchical testing

NI.D3(p=rep(0.005, 15), Se=0.99, Sp=0.99, group.sz=15,
obj.fn=c("ET", "MAR", "GR"),
weights=matrix(data=c(1,1,10,10), nrow=2, ncol=2, byrow=TRUE))

}
\references{
\emph{Graff, L.E. & Roeloffs, R. (1972)}. Group testing in the presence of test error;
an extension of the Dorfman procedure. \emph{Technometrics, 14, 113-122}.

\emph{Kim, H.Y.; Hudgens, M.G.; Dreyfuss, J.M.; Westreich, D.J. & Pilcher, C.D. (2007)}.
Comparison of group testing algorithms for case identification in the presence of test error.
\emph{Biometrics, 63, 1152-1163}.

\emph{Malinovsky, Y.; Albert, P.S. & Roy, A. (2016)}. Reader reaction: A note on the
evaluation of group testing algorithms in the presence of misclassification.
\emph{Biometrics, 72, 299-302}.
}
\seealso{
\code{\link{Inf.D3}} for informative three-stage hierarchical testing

\code{\link{OTC}} for finding the optimal testing configuration for a
number of standard group testing algorithms

\url{http://chrisbilder.com/grouptesting/HBTM}

Other Optimal Testing Configuration functions: \code{\link{Inf.Array}},
  \code{\link{Inf.D3}}, \code{\link{Inf.Dorf}},
  \code{\link{NI.A2M}}, \code{\link{NI.Array}},
  \code{\link{NI.Dorf}}, \code{\link{OTC}}
}
\author{
Brianna Hitt
}
