% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hierarchical.Functions.R
\name{beta.dist}
\alias{beta.dist}
\title{Expected value of order statistics from a beta distribution}
\usage{
beta.dist(p = 0.05, alpha = 1, beta = NULL, grp.sz = 10,
  simul = FALSE, plot = FALSE, rel.tol = ifelse(a >= 1,
  .Machine$double.eps^0.25, .Machine$double.eps^0.1))
}
\arguments{
\item{p}{average probability, \eqn{\frac{\alpha}{\alpha + \beta}}.}

\item{alpha}{the alpha parameter for the beta distribution. The 
details of the specification of \kbd{alpha} are given under 'Details'.}

\item{beta}{the beta parameter for the beta distribution, which is
calculated from the average probability, \kbd{p}, if it is not
specified. The details of the specification of \kbd{beta} are 
given under 'Details'.}

\item{grp.sz}{the number of individuals in the group.}

\item{simul}{a logical value indicating whether to use simulation. 
If simulation is used, the vector of probabilities is found by 
simulating 10,000 values from a beta distribution with
the specified shape parameters. If simulation is not used, 
the vector of individual probabilities is found using integration.}

\item{plot}{a logical value indicating whether to plot the 
distribution with p(i) marked.}

\item{rel.tol}{relative tolerance used for integration.}
}
\value{
A vector of ordered probabilities, p_i.
}
\description{
Get the expected value of order statistics, E(p(i)), 
from a beta distribution by specifying an average probability 
and shape parameters for the beta distribution.
}
\details{
If \kbd{alpha} = 0, this function uses an extreme value 
distribution based on a Bernoulli(p) distribution to  find the 
individual probabilities, p_i. If \kbd{alpha} is infinite, this 
function uses \eqn{p_i=p} for all i.

If \kbd{beta} is not specified, it is calculated from the average
probability \kbd{p} as \eqn{b=a*\frac{1}{p-1}}. If \kbd{beta} is 
specified, this function ignores \kbd{p} unless \kbd{alpha} is 
infinite.

Depending on the specified probability, alpha level, and overall 
group size, simulation may be necessary in order to generate the 
vector of individual probabilities. In this case, the user should
specify \kbd{simul=TRUE} and set a seed in order to reproduce results. 
See Black et al. (2015) for additional details.
}
\examples{
# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
set.seed(8791)
beta.dist(p=0.05, alpha=1, grp.sz=30)

# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
set.seed(1002)
beta.dist(p=0.02, alpha=2, grp.sz=50, simul=TRUE)

# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
set.seed(5732)
beta.dist(alpha=2, beta=5, grp.sz=15, plot=TRUE)
}
\references{
\insertRef{Black2015}{binGroup}
}
\seealso{
\url{http://chrisbilder.com/grouptesting}

\code{\link{p.vec.func}} for generating a vector of individual
risk probabilities for informative group testing (after checking 
whether simulation is needed) and \code{\link{Informative.array.prob}} 
for arranging a vector of individual risk probabilities in a matrix 
for informative array testing without master pooling.

Other Individual risk probability functions: \code{\link{Informative.array.prob}},
  \code{\link{p.vec.func}}
}
\author{
This function was originally written by Michael S. 
Black for Black et al. (2015). The function was obtained 
from \url{http://chrisbilder.com/grouptesting}.
}
