% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dorfman.Functions.R
\name{pool.specific.dorf}
\alias{pool.specific.dorf}
\title{Find the optimal pool sizes for Pool-Specific Optimal Dorfman 
(PSOD) testing}
\usage{
pool.specific.dorf(p, max.p, se, sp)
}
\arguments{
\item{p}{a vector of each individual's probability of infection.}

\item{max.p}{the maximum allowable pool size.}

\item{se}{the sensitivity of the diagnostic test.}

\item{sp}{the specificity of the diagnostic test.}
}
\value{
The optimal set of pool sizes for PSOD testing.
}
\description{
Find the set of optimal pool sizes for Pool-Specific 
Optimal Dorfman (PSOD) testing.
}
\details{
This function finds the set of optimal pool sizes for PSOD
testing. PSOD testing uses a greedy algorithm and does not consider
all possible sets of pool sizes. See McMahan et al. (2012) for 
additional details on the implementation of PSOD testing.
}
\examples{
# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
set.seed(8135)
p.vec <- p.vec.func(p=0.02, alpha=1, grp.sz=10)
pool.specific.dorf(p=p.vec, max.p=3, se=0.95, sp=0.95)
}
\references{
\insertRef{McMahan2012a}{binGroup}
}
\seealso{
\url{http://chrisbilder.com/grouptesting}

Other Informative Dorfman functions: \code{\link{accuracy.dorf}},
  \code{\link{characteristics.pool}},
  \code{\link{inf.dorf.measures}},
  \code{\link{opt.info.dorf}}, \code{\link{opt.pool.size}},
  \code{\link{thresh.val.dorf}}
}
\author{
This function was originally written by Christopher S. 
McMahan for McMahan et al. (2012). The function was obtained 
from \url{http://chrisbilder.com/grouptesting}.
}
