% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binOperators.R
\name{negate}
\alias{negate}
\title{Binary Negation (!)}
\usage{
negate(x)
}
\arguments{
\item{x}{The number to be negated. A binary vector is expected.}
}
\value{
The negated number of x. Returns a binary vector with signed=TRUE
}
\description{
Negates the binary number x. Negation x -> -x or -x -> x
}
\details{
An »unsigned« number will be returned as »signed« regardless of whether the value is negative. 
No floating point supported.
}
\examples{
summary(negate(as.binary(5, signed=TRUE)))
summary(negate(as.binary(-5, signed=TRUE)))
summary(negate(as.binary(5, signed=FALSE)))
}
\seealso{
\link{switchEndianess} or \link{fillUpToByte}.
}

