% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajData.R
\name{trajData}
\alias{trajData}
\title{creates the data which serves as input for the "trajPlot" function.}
\usage{
trajData(
  x,
  nodata = 2,
  category = 1,
  spres = c(1000, 1000),
  datacrs = NULL,
  unified = "yes"
)
}
\arguments{
\item{x}{is the data, which must be a RasterStack,RasterBrick,SpatRaster or data frame.}

\item{nodata}{is alphanumeric, which denotes no data in the data set.}

\item{category}{is the category of interest. The default is set to 1.}

\item{spres}{is a 1*2 vector indicating the spatial resolution of the data. The default is c(1000,1000).}

\item{datacrs}{is the CRS of the input data.}

\item{unified}{is a string, which can be "yes" or "no" only. If "yes," the change is a percentage of a region's
unified area; else, the change is a percentage of the entire region under consideration.}
}
\value{
The output from \code{\link{trajData}}
}
\description{
creates the data which serves as input for the "trajPlot" function.
}
\examples{
example_data <- terra::rast(system.file("external/Example_raster_Y.tif",package="binaryTimeSeries"))
no_data <- 2
cat_interest <- 1
data_res <- c(1000,1000)
data_prj <- "+proj=utm +zone=32 +datum=WGS84 +ellps=GRS80  +units=m +no_defs"
unified_resp <- "yes"
trajdt_output <- trajData(x = example_data,nodata = no_data,
category = cat_interest,spres = data_res,datacrs = data_prj,
unified = unified_resp)

}
