% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parts.R
\name{parts}
\alias{name}
\alias{name.taxon}
\alias{name.taxonref}
\alias{parts}
\alias{rank}
\alias{rank.taxon}
\alias{rank.taxonref}
\alias{taxonid}
\alias{taxonid.taxon}
\alias{taxonid.taxonref}
\alias{uri}
\alias{uri.taxon}
\alias{uri.taxonref}
\title{Pick out parts by name}
\usage{
name(x, unname = TRUE)

\method{name}{taxon}(x, unname = TRUE)

\method{name}{taxonref}(x, unname = TRUE)

uri(x, unname = TRUE)

\method{uri}{taxon}(x, unname = TRUE)

\method{uri}{taxonref}(x, unname = TRUE)

rank(x, unname = TRUE)

\method{rank}{taxon}(x, unname = TRUE)

\method{rank}{taxonref}(x, unname = TRUE)

taxonid(x, unname = TRUE)

\method{taxonid}{taxon}(x, unname = TRUE)

\method{taxonid}{taxonref}(x, unname = TRUE)
}
\arguments{
\item{x}{Input, object of class taxon or taxonref}

\item{unname}{(logical) Unname output elements? Ignored when input is of class
\code{taxonref}. Default: \code{TRUE}}
}
\value{
For \code{taxon} inputs, gives back a \code{taxonref} object. For \code{taxondf}
inputs, gives back \code{taxondf}.
}
\description{
This suite of functions act on taxon or taxonref objects,
and pick out object elements by the name of the function.
}
\examples{
# operating on `taxon` objects
out <- make_taxon(genus="Poa", epithet="annua", authority="L.",
   family='Poaceae', clazz='Poales', kingdom='Plantae', variety='annua')

out \%>\% name()
out \%>\% uri()
out \%>\% rank()
out \%>\% taxonid()

## or don't unname the output
out \%>\% name(unname = FALSE)

# operating on `taxonref` objects
res <- taxonref("genus", "Poa", 56, "http://scottchamberlain.info/")
res \%>\% name()
res \%>\% uri()
res \%>\% rank()
res \%>\% taxonid()
}

