% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_basemap.R
\name{download_basemap}
\alias{download_basemap}
\title{Download a basemap for \code{map(ppi)}}
\usage{
download_basemap(x, verbose = TRUE, zoom, alpha = 1,
  source = "stamen", ...)
}
\arguments{
\item{x}{An object of class \code{ppi}.}

\item{verbose}{Logical, whether to print information to console.}

\item{zoom}{Zoom level (optional), see \link[ggmap]{get_map}. An integer
from 3 (continent) to 21 (building). By default the zoom level matching the
ppi extent is selected automatically.}

\item{alpha}{Transparency of the basemap (0-1).}

\item{source}{String identifying which map service should be used: "google", "osm" or "stamen"}

\item{...}{Arguments to pass to \link[ggmap]{get_map} function. Note arguments \code{maptype} and \code{source}
for selection of different types of basemaps.}
}
\description{
Downloads a Google Maps, OpenStreetMap, Stamen Maps or Naver Map base
layer map using \link[ggmap]{get_map}.
}
\examples{
# load an example scan:
data(example_scan)
# print summary info for the scan:
example_scan
# make ppi for the scan
ppi <- project_as_ppi(example_scan)
# grab a basemap that matches the extent of the ppi:
\dontrun{
basemap <- download_basemap(ppi)
# map the reflectivity quantity of the ppi onto the basemap:
map(ppi, map = basemap, param = "DBZH")
# download a different type of basemap, e.g. satellite imagery:
# see get_map() in ggmap library for full documentation of options
basemap <- download_basemap(ppi, maptype = "satellite")
# map the radial velocities onto the satellite imagery:
map(ppi, map = basemap, param = "VRADH")
}
}
