% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vp.R
\name{summary.vp}
\alias{summary.vp}
\alias{is.vp}
\alias{dim.vp}
\title{Class \code{vp}: a vertical profile of birds}
\usage{
\method{summary}{vp}(object, ...)

is.vp(x)

\method{dim}{vp}(x)
}
\arguments{
\item{object}{An object of class \code{vp}.}

\item{...}{Additional arguments affecting the summary produced.}

\item{x}{An object of class \code{vp}.}
}
\value{
For \code{is.vp}: \code{TRUE} if its argument is of class \code{vp}.

For \code{dim.vp}: dimensions of the profile data.
}
\description{
Class \code{vp} for a vertical profile of birds, and its associated R base
functions.
}
\details{
An object of class \code{vp} contains a vertical profile. A vertical profile
contains a collection of quantities, with each quantity having values at
different altitude layers above the earth's surface, typically equally
spaced altitudinal layers.

Data contained in this class object should be accessed with the
\link{get_quantity} function. Information stored under \code{attributes}
(see below) can be accessed directly.

A \code{vp} object is a list containing
\describe{
 \item{\strong{\code{radar}}}{the radar identifier}
 \item{\strong{\code{datetime}}}{the nominal time of the profile}
 \item{\strong{\code{data}}}{the profile data, a list containing:
   \describe{
       \item{\code{HGHT}}{height above mean sea level [m]. Alt. bin from HGHT to HGHT+interval)}
       \item{\code{u}}{speed component west to east [m/s]}
       \item{\code{v}}{speed component north to south [m/s]}
       \item{\code{w}}{vertical speed (unreliable!) [m/s]}
       \item{\code{ff}}{horizontal speed [m/s]}
       \item{\code{dd}}{direction [degrees, clockwise from north]}
       \item{\code{sd_vvp}}{VVP radial velocity standard deviation [m/s]}
       \item{\code{gap}}{Angular data gap detected [T/F]}
       \item{\code{dbz}}{Bird reflectivity factor [dBZ]}
       \item{\code{eta}}{Bird reflectivity [cm^2/km^3]}
       \item{\code{dens}}{Bird density [birds/km^3]}
       \item{\code{DBZH}}{Total reflectivity factor (bio+meteo scattering) [dBZ]}
       \item{\code{n}}{number of points VVP bird velocity analysis (u,v,w,ff,dd)}
       \item{\code{n_all}}{number of points VVP st.dev. estimate (sd_vvp)}
       \item{\code{n_dbz}}{number of points bird density estimate (dbz,eta,dens)}
       \item{\code{n_dbz_all}}{number of points total reflectivity estimate (DBZH)}
   }
 }
 \item{\strong{\code{attributes}}}{list with the profile's \code{\\what},
 \code{\\where} and \code{\\how} attributes}
}
}
