% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_vpfiles.R
\name{select_vpfiles}
\alias{select_vpfiles}
\title{Select vertical profile (\code{vp}) files from computer}
\usage{
select_vpfiles(
  date_min = NULL,
  date_max = NULL,
  radars = NULL,
  directory = "."
)
}
\arguments{
\item{date_min}{character. YYYY-MM-DD start date of file selection.}

\item{date_max}{character. YYYY-MM-DD end date of file selection.}

\item{radars}{character (vector). 5-letter country/radar code(s) (e.g.
\code{bejab}) of radars to include in file selection.}

\item{directory}{character. Path to local directory where files should be
looked for.}
}
\value{
Character vector of file paths that comply to the given date and
  radar range.
}
\description{
Create a list of vertical profile (\code{vp}) files from a local directory
that match a specific date and radar range. Files are selected based on their
file name (not directory structure), which should be of format
\code{radar_vp_yyyymmdd*.*}, such as \code{bewid_vp_20171123T1900Z_0x5.h5}.
}
\examples{
select_vpfiles(
  date_min = "2016-10-03",
  date_max = "2016-10-05",
  radars = "bejab",
  directory = "my_data"
)
}
