% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beam.R
\name{beam_distance}
\alias{beam_distance}
\title{Calculate radar beam distance}
\usage{
beam_distance(range, elev, k = 4/3, lat = 35, re = 6378, rp = 6357)
}
\arguments{
\item{range}{Numeric. Slant range, i.e. the length of the skywave path
between target and the radar antenna, in m.}

\item{elev}{Numeric. Beam elevation, in degrees.}

\item{k}{Numeric. Standard refraction coefficient.}

\item{lat}{Numeric. Geodetic latitude of the radar, in degrees.}

\item{re}{Numeric. Earth equatorial radius, in km.}

\item{rp}{Numeric. Earth polar radius, in km.}
}
\value{
Beam distance (down range), in m.
}
\description{
Calculates the distance as measured over the earth's surface (the down range)
for a given beam elevation and slant range.
}
\details{
depends on \link{beam_height} to calculate beam height.
}
\examples{
# Down range of the 5 degree elevation beam at a slant range of 100 km:
beam_distance(100000, 5)
}
\seealso{
\itemize{
\item \code{\link[=beam_height]{beam_height()}}
}

Other beam_functions: 
\code{\link{beam_height}()},
\code{\link{beam_profile_overlap}()},
\code{\link{beam_profile}()},
\code{\link{beam_range}()},
\code{\link{beam_width}()},
\code{\link{gaussian_beam_profile}()}
}
\concept{beam_functions}
