% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpfile.R
\name{is.vpfile}
\alias{is.vpfile}
\title{Check if a file is a vertical profile (\code{vp})}
\usage{
is.vpfile(file)
}
\arguments{
\item{file}{Character. Path of the file to check.}
}
\value{
\code{TRUE} for a vertical profile file in readable format, otherwise
\code{FALSE}.
}
\description{
Checks whether a file is a vertical profile (\code{vp}) in the ODIM HDF5 format
that can be read with bioRad.
}
\examples{
# Locate the vertical profile example file
vpfile <- system.file("extdata", "profile.h5", package = "bioRad")

# Check if it is a vpfile
is.vpfile(vpfile)
}
\seealso{
\itemize{
\item \code{\link[=read_vpfiles]{read_vpfiles()}}
\item \code{\link[=get_odim_object_type]{get_odim_object_type()}}
\item \code{\link[=is.vp]{is.vp()}}
}
}
