% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_interlab.R
\name{summary_curve_tables}
\alias{summary_curve_tables}
\title{Summary and curve tables}
\usage{
summary_curve_tables(num_labs, list_lab_names, all_rds)
}
\arguments{
\item{num_labs}{number of laboratories participating.}

\item{list_lab_names}{list with the laboratory names.}

\item{all_rds}{list with the rds files.}
}
\value{
list(sorted_table_ilc, sorted_table_curve)
}
\description{
Summary and curve tables
}
\examples{
#fit_results_X is the output from the Estimation module

fit_results_A1 <- system.file("extdata", "A1_Estimation_results.rds", package = "biodosetools") \%>\%
  readRDS()

fit_results_A2 <- system.file("extdata", "A2_Estimation_results.rds", package = "biodosetools") \%>\%
  readRDS()



summary_curve_tables(num_labs = 2,
                     list_lab_names = c("A", "B"),
                     all_rds = list(fit_results_A1, fit_results_A2)
                     )
}
