% Generated by roxygen2 (4.0.2): do not edit by hand
\name{count_multigrams}
\alias{count_multigrams}
\title{Detect and count multiple n-grams in sequences}
\usage{
count_multigrams(n_d, seq, u, d = 0, pos = FALSE, scale = FALSE,
  threshold = 0)
}
\arguments{
\item{n_d}{\code{list} list of n-grams' sizes and distances between elements of n-gram.
See Details.}

\item{seq}{\code{integer} vector or matrix describing sequence(s).}

\item{u}{unigrams (\code{integer}, \code{numeric} or \code{character} vector).}

\item{d}{\code{integer} vector of distances between elements of n-gram (0 means
consecutive elements). See Details.}

\item{pos}{\code{logical}, if \code{TRUE} n_grams contains position information.}

\item{scale}{\code{logical}, if \code{TRUE} output data is normalized. Should be
used only for n-grams without position information. See \code{Details}.}

\item{threshold}{\code{integer}, if not equal to 0, data is binarized into
two groups (larger or equal to threshold, smaller than threshold).}
}
\value{
a \code{integer} matrix with named columns. The naming conventions are the same
as in \code{\link{count_ngrams}}.
}
\description{
A convinient wrapper around \code{\link{count_ngrams}} for counting multiple
values of \code{n} and \code{d}.
}
\details{
Each element of \code{n_d} is a list consisting of two vectors.
First element is a single \code{integer} value which determines the number of
words in n-gram (equivalent of \code{n} from \code{\link{count_ngrams}}). Second
element must be an \code{integer} vector describing distances between words in
n-gram (equivalent of \code{d} from \code{\link{count_ngrams}}).
}
\examples{
seqs <- matrix(sample(1L:4, 600, replace = TRUE), ncol = 50)
count_multigrams(list(list(2, 1), list(2, 3)), seqs, 1L:4, pos = TRUE)
}

