% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/bigelow_model.R
\name{dBigelow_model}
\alias{dBigelow_model}
\title{First Derivate of the Linear Bigelow Model}
\usage{
dBigelow_model(t, x, parms, temp_profile)
}
\arguments{
\item{t}{numeric vector indicating the time of the experiment.}

\item{x}{list with the value of N at t.}

\item{parms}{parameters for the secondary model. No explicit check of their
validity is performed.}

\item{temp_profile}{a function that provides the temperature at a given
       time.}
}
\value{
The value of the first derivative of \eqn{N} at time \code{t} as a
        list.
}
\description{
Calculates the first derivative of the linearized version of Bigelow's model
for dynamic problems at a given time for the model parameters provided and
the environmental conditions given.
}
\details{
The model is developed from the isothermal Bigelow's model assuming during
the derivation process that \eqn{D_T} is time independenent.

This function is compatible with the function
\code{\link{predict_inactivation}}.
}
\section{Model Equation}{


   \deqn{\frac{dN}{dt} = - N \frac {\mathrm{ln}(10)}{D_T(T)}}{
         dN/dt = - N * ln(10)/D_T(T)}
}

\section{Model parameters}{

     \itemize{
         \item temp_ref: Reference temperature for the calculation,
         \item D_R: D-value at the reference temperature,
         \item z: z value.
         }
}
\seealso{
\code{\link{predict_inactivation}}
}

