% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull-peleg_model.R
\name{dPeleg_model}
\alias{dPeleg_model}
\title{First Derivate of the Weibull-Peleg Model}
\usage{
dPeleg_model(t, x, parms, temp_profile)
}
\arguments{
\item{t}{numeric vector indicating the time of the experiment.}

\item{x}{list with the value of logS at t.}

\item{parms}{parameters for the secondary model. No explicit check of their validity
is performed (see section \bold{Model Parameters}).}

\item{temp_profile}{a function that provides the temperature at a given time.}
}
\value{
The value of the first derivative of logS at time \code{t} as a list.
}
\description{
Calculates the first derivative of Weibull-Peleg model at a given time for
the model parameters provided and the environmental conditions given.
}
\details{
The model is developed from the isothermal Weibull model without
taking into
account in the derivation the time dependence of \eqn{b} for
non-isothermal temperature profiles.

This function is compatible with the function
\code{\link{predict_inactivation}}.
}
\section{Model Equation}{

     \deqn{\frac{d(\mathrm{log}_{10}(S))}{dt}=-b(T) \cdot n \cdot
                (- log10(S)/b(T))^{(n-1)/n)} }{
           d(log10(S))/dt = -b * n *( - log10(S)/b )^( (n-1)/n)}

     \deqn{b(T) = \mathrm{ln}(1 + exp( k_b*(T - T_{crit}) ))}{
           b(T) = ln( 1 + exp( k_b*(T - T_crit) ) )}
}

\section{Model Parameters}{

     \itemize{
         \item temp_crit: Temperature below which there is inactivation.
         \item k_b: slope of the b ~ temp line for temperatures above the
                    critical one.
         \item n: shape factor of the Weibull distribution.
         }
}

\section{Note}{

     For logS=0, dlogS = 0 unless n=1. Hence, a small shift needs to be introduced
     to logS.
}

\seealso{
\code{\link{predict_inactivation}}
}
