% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_predictions.R
\name{predict_inactivation}
\alias{predict_inactivation}
\title{Prediction of Dynamic Inactivation}
\usage{
predict_inactivation(simulation_model, times, parms, temp_profile, ...,
  tol0 = 1e-05)
}
\arguments{
\item{simulation_model}{character identifying the model to be used.}

\item{times}{numeric vector of output times.}

\item{parms}{list of parameters defining the parameters of the model.}

\item{temp_profile}{data frame with discrete values of the temperature for
each time. It must have one column named \code{time} and another named
\code{temperature} providing discrete values of the temperature at
time points.}

\item{...}{Additional arguments passed to \code{\link{ode}}.}

\item{tol0}{numeric. Observations at time 0 make Weibull-based models singular.
The time for observatins taken at time 0 are changed for this value.
By default (`tol0 = 1e-5`)}
}
\value{
A list of class \code{SimulInactivation} with the results. It has
        the following entries:
        \itemize{
          \item model: character defining the model use for the prediction.
          \item model_parameters: named numeric vector with the values of
                                  the model parameters used.
          \item temp_approximations: function used for the interpolation of
                                     the temperature. For a numeric value of
                                     time given, returns the value of the
                                     temperature and its first derivative.
          \item simulation: A data frame with the results calculated. Its
                            first column contains the times at which the
                            solution has been calculated. The following
                            columns the values of the variables of the
                            model. The three last columns provide the
                            values of \code{logN}, \code{S} and
                            \code{logS}.
          }
}
\description{
Predicts the inactivation of a microorganism under isothermal or
non-isothermal temperature conditions. The thermal resistence of
the microorganism are defined with the input arguments.
}
\details{
The value of the temperature is calculated at each value of time by
linear interpolation of the values provided by the input argument
\code{temp_profile}.
The function \code{\link{ode}} of the package \code{\link{deSolve}} is
used for the resolution of the differential equation.
}
\examples{
## EXAMPLE 1 -----------

## Retrieve the model keys available for dynamic models.
get_model_data()

## Set the input arguments
example_model <- "Geeraerd"  # Geeraerd's model will be used
times <- seq(0, 5, length=100)  # values of time for output

model_data <- get_model_data(example_model)  # Retrive the data of the model used
print(model_data$parameters)
print(model_data$variables)
model_parms <- c(D_R = 1,
                 z = 10,
                 N_min = 100,
                 temp_ref = 100,
                 N0 = 100000,
                 C_c0 = 1000
                 )

## Define the temperature profile for the prediction
temperature_profile <- data.frame(time = c(0, 1.25, 2.25, 4.6),
                                  temperature = c(70, 105, 105, 70))

## Call the prediction function
prediction_results <- predict_inactivation(example_model, times,
                                           model_parms, temperature_profile)

## Show the results
head(prediction_results$simulation)
plot(prediction_results)

## END EXAMPLE 1 -----------

}
\seealso{
\code{\link{ode}}, \code{\link{get_model_data}}
}
