% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMetaGenomes.R
\name{getMetaGenomes}
\alias{getMetaGenomes}
\title{Retrieve metagenomes from NCBI Genbank}
\usage{
getMetaGenomes(name, path = file.path("_ncbi_downloads", "metagenome"))
}
\arguments{
\item{name}{metagenome name retrieved by \code{\link{listMetaGenomes}}.}

\item{path}{a character string specifying the location (a folder) in 
which the corresponding metagenome shall be stored. 
Default is \code{path} = \code{file.path("_ncbi_downloads","metagenome")}.}
}
\description{
Retrieve available metagenomes from NCBI Genbank. 
NCBI Genbank allows users to download entire metagenomes of several 
metagenome projects. This function downloads available metagenomes that can 
then be downloaded via \code{\link{getMetaGenomes}}.
}
\examples{
\dontrun{
# Frist, retrieve a list of available metagenomes
listMetaGenomes()

# Now, retrieve the 'human gut metagenome'
getMetaGenomes(name = "human gut metagenome")
}
}
\seealso{
\code{\link{getMetaGenomeAnnotations}}, 
\code{\link{listMetaGenomes}}
}
\author{
Hajk-Georg Drost
}
