'BIOMOD_EnsembleModeling' <- function( modeling.output,
                                       chosen.models = 'all',
                                       em.by = 'all',
                                       eval.metric = 'all',
                                       eval.metric.quality.threshold = NULL,
                                       prob.mean = TRUE,
                                       prob.cv = FALSE,
                                       prob.ci = FALSE,
                                       prob.ci.alpha = 0.05,
                                       prob.median = FALSE,
                                       committee.averaging = FALSE,
                                       prob.mean.weight = FALSE,
                                       prob.mean.weight.decay = 'proportional',
                                       VarImport=0){
  .bmCat("Build Ensemble Models")
  # 1. args checking -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- #
  args <- .BIOMOD_EnsembleModeling.check.args( modeling.output,
                                               chosen.models,
                                               eval.metric,
                                               eval.metric.quality.threshold,
                                               prob.mean,
                                               prob.cv,
                                               prob.ci,
                                               prob.ci.alpha,
                                               prob.median,
                                               committee.averaging,
                                               prob.mean.weight,
                                               prob.mean.weight.decay,
                                               em.by)
  
  modeling.output <- args$modeling.output
  chosen.models <- args$chosen.models
  eval.metric <- args$eval.metric
  eval.metric.quality.threshold <- args$eval.metric.quality.threshold
  prob.mean <- args$prob.mean
  prob.cv <- args$prob.cv
  prob.ci <- args$prob.ci
  prob.ci.alpha <- args$prob.ci.alpha
  prob.median <- args$prob.median
  committee.averaging <- args$committee.averaging
  prob.mean.weight <- args$prob.mean.weight
  prob.mean.weight.decay  <- args$prob.mean.weight.decay
  em.by <- args$em.by
  
  rm('args')
  
  em.avail <- c('prob.mean', 'prob.cv', 'prob.ci.inf', 'prob.ci.sup', 'prob.median', 'committee.averaging', 'prob.mean.weight')
  em.algo <- em.avail[c(prob.mean, prob.cv, prob.ci, prob.ci, prob.median, committee.averaging, prob.mean.weight)]
  
  # create a EM option list
  Options <- list(em.by=em.by)
  expl_var_type = get_var_type(get_formal_data(modeling.output,'expl.var'))
  expl_var_range = get_var_range(get_formal_data(modeling.output,'expl.var'))
  
  
  # 1b. creating output object and begin to fill it
#   EM <- list()
  EM <- new('BIOMOD.EnsembleModeling.out',
            sp.name = modeling.output@sp.name,
            expl.var.names = modeling.output@expl.var.names,
            em.by = em.by,
            modeling.id = modeling.output@modeling.id
#             models.out.obj = new('BIOMOD.stored.models.out',
#                                  inMemory = FALSE,
#                                  link = paste(modeling.output@sp.name,"/",modeling.output@sp.name,".models.out",sep="")),
#             eval.metric = eval.metric,
#             eval.metric.quality.threshold = eval.metric.quality.threshold#,
#             em.ci.alpha = prob.ci.alpha
            )
  
  EM@models.out.obj@link <- file.path(modeling.output@sp.name,paste(modeling.output@sp.name,".", modeling.output@modeling.id,".models.out",sep="") )
  
  # 2. doing Ensemble modeling
  
  ## 2.1 make a list of models names that will be combined together according to by argument.
  em.mod.assemb <- .em.models.assembling(chosen.models, em.by)

  for(assemb in names(em.mod.assemb) ){
    cat("\n\n  >", assemb, "ensemble modeling")
    models.kept <- em.mod.assemb[[assemb]]
    
    #### defined data that will be used for models performances calculation ####
    if(modeling.output@has.evaluation.data){
      eval.obs <- get_formal_data(modeling.output,'eval.resp.var')
      eval.expl <- get_formal_data(modeling.output,'eval.expl.var')
    }
    
    ##### !!!!!! TO DO -> select appropriate part of dataset according to em.by
    if(em.by %in% c("PA_dataset",'PA_dataset+algo','PA_dataset+repet')){
      obs <-  get_formal_data(modeling.output,'resp.var')
      expl <- get_formal_data(modeling.output,'expl.var')
      if(head(unlist(strsplit(assemb,"_")),1) != 'AllData'){
        kept_cells <- get_formal_data(modeling.output)@PA[, paste(head(unlist(strsplit(assemb,"_")),1))]
        obs <- obs[kept_cells]
        expl <- expl[kept_cells, ,drop=F]
      }                              
    }   
    if(em.by %in% c("algo","all") ){
      ## we need to take all data even if it is much better to have 
      obs <-  get_formal_data(modeling.output,'resp.var')
      expl <- get_formal_data(modeling.output,'expl.var')
    }                                        
    # remove na
    obs[is.na(obs)] <- 0
    
    
    
  
    #### get needed models predictions ####
    needed_predictions <- .get_needed_predictions(modeling.output, em.by, models.kept, eval.metric, eval.metric.quality.threshold)
    # if no prediction selected => swith to next model
    if(!length(needed_predictions)) next

    ## loop on evaluation metrics ##
    for(eval.m in eval.metric){
      
      # define model name
      base_model_name <- paste(modeling.output@sp.name,"_",assemb,"_",eval.m,'_' ,sep="")
      models.kept <- needed_predictions$models.kept[[eval.m]]
      models.kept.scores <- needed_predictions$models.kept.scores[[eval.m]]
      
      ## Loop over em.algo ##
      
      for(algo in em.algo){
        #### Models building ####
        
        # 1. Mean of probabilities -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- #
        if(algo == 'prob.mean'){
          cat("\n   > Mean of probabilities...")
          
          model_name <- paste(base_model_name,"EMmean",sep="")
          
          model.bm <- new("EMmean_biomod2_model",
                           model = models.kept,
                           model_name = model_name,
                           model_class = 'EMmean',
                           model_options = Options,
                           resp_name = modeling.output@sp.name,
                           expl_var_names = modeling.output@expl.var.names,
                           expl_var_type = expl_var_type,
                           expl_var_range = expl_var_range,
                           modeling.id = modeling.output@modeling.id)
        }
        
        # 2. CV of probabilities -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- #
        if(algo == 'prob.cv'){
          cat("\n   > Coef of variation of probabilities...")
          model_name <- paste(base_model_name,"EMcv",sep="")
          
          model.bm <- new("EMcv_biomod2_model",
                           model = models.kept,
                           model_name = model_name,
                           model_class = 'EMcv',
                           model_options = Options,
                           resp_name = modeling.output@sp.name,
                           expl_var_names = modeling.output@expl.var.names,
                           expl_var_type = expl_var_type,
                           expl_var_range = expl_var_range,
                           modeling.id = modeling.output@modeling.id)
        }
        
        # 3. Median of probabilities -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- #
        if(algo == 'prob.median'){
          cat("\n   > Median of ptobabilities...")
          model_name <- paste(base_model_name,"EMmedian",sep="")
          
          model.bm <- new("EMmedian_biomod2_model",
                           model = models.kept,
                           model_name = model_name,
                           model_class = 'EMmedian',
                           model_options = Options,
                           resp_name = modeling.output@sp.name,
                           expl_var_names = modeling.output@expl.var.names,
                           expl_var_type = expl_var_type,
                           expl_var_range = expl_var_range,
                           modeling.id = modeling.output@modeling.id)
        }
        
        # 4. CI of probabilities -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- #
        if(algo == 'prob.ci.inf'){
          cat("\n   > Confidence Interval...")
          
          ## Quantile inferior
          model_name <- paste(base_model_name,"EMciInf",sep="")
          
          model.bm <- new("EMci_biomod2_model",
                           model = models.kept,
                           model_name = model_name,
                           model_class = 'EMci',
                           model_options = Options,
                           resp_name = modeling.output@sp.name,
                           expl_var_names = modeling.output@expl.var.names,
                           expl_var_type = expl_var_type,
                           expl_var_range = expl_var_range,
                           modeling.id = modeling.output@modeling.id,
                           alpha = prob.ci.alpha,
                           side = 'inferior')
        }

        if(algo == 'prob.ci.sup'){
          ## Quantile superior
          model_name <- paste(base_model_name,"EMciSup",sep="")
          
          model.bm <- new("EMci_biomod2_model",
                           model = models.kept,
                           model_name = model_name,
                           model_class = 'EMci',
                           model_options = Options,
                           resp_name = modeling.output@sp.name,
                           expl_var_names = modeling.output@expl.var.names,
                           expl_var_type = expl_var_type,
                           expl_var_range = expl_var_range,
                           modeling.id = modeling.output@modeling.id,
                           alpha = prob.ci.alpha,
                           side = 'superior') 
          
        }
        
        # 5. Comitee averaging of probabilities -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= #
        if(algo == 'committee.averaging'){      
          cat("\n   >  Comittee averaging...")
          model_name <- paste(base_model_name,"EMca",sep="")
          
          models.kept.tresh <- unlist(lapply(models.kept, function(x){
            mod <- tail(unlist(strsplit(x,"_")), 3)[3]
            run <- tail(unlist(strsplit(x,"_")), 3)[2]
            dat <- tail(unlist(strsplit(x,"_")), 3)[1]
            return(get_evaluations(modeling.output)[eval.m, "Cutoff", mod, run, dat])
          }))
          names(models.kept.tresh) <- models.kept
          
          model.bm <- new("EMca_biomod2_model",
                           model = models.kept,
                           model_name = model_name,
                           model_class = 'EMca',
                           model_options = Options,
                           resp_name = modeling.output@sp.name,
                           expl_var_names = modeling.output@expl.var.names,
                           expl_var_type = expl_var_type,
                           expl_var_range = expl_var_range,
                           modeling.id = modeling.output@modeling.id,
                           tresholds = models.kept.tresh) 

        }
        
        # 6. weighted mean of probabilities -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= #
        if(algo == 'prob.mean.weight'){
          cat("\n   > Prababilities wegthing mean...")
          model_name <- paste(base_model_name,"EMwmean",sep="")
          
          # remove SRE models if ROC
          models.kept.tmp <- models.kept
          models.kept.scores.tmp <- models.kept.scores
#           prediction.kept.tmp <- prediction.kept
          
          if(eval.m == 'ROC'){
            sre.id <- grep("_SRE", models.kept)
            if(length(sre.id)>0){
              cat("\n      ! SRE modeling were switched off")
              models.kept.tmp <- models.kept[-sre.id]
              models.kept.scores.tmp <- models.kept.scores[-sre.id]
#               prediction.kept.tmp <- prediction.kept[,models.kept]
            }
          }
          
          # weights are "decay" times decreased for each subsequent model in model quality order.
          models.kept.scores.tmp <- round(models.kept.scores.tmp, 3) # sometimes there can be a rounding issue in R, so here I make sure all values are rounded equally.
          
          # dealing with numerical decay
          if(is.numeric(prob.mean.weight.decay)){
            DecayCount <- sum(models.kept.scores.tmp>0)
            WOrder <- order(models.kept.scores.tmp, decreasing=T)
            Dweights <- models.kept.scores.tmp
            for(J in 1:DecayCount) Dweights[WOrder[J]] <- (DecayCount - J + 1) * prob.mean.weight.decay
            #If 2 or more score are identical -> make a mean weight between the ones concerned
            for(J in 1:length(models.kept.scores.tmp)){
              if(sum(models.kept.scores.tmp[J]==models.kept.scores.tmp)>1) Dweights[which(models.kept.scores.tmp[J]==models.kept.scores.tmp)] <- mean(Dweights[which(models.kept.scores.tmp[J]==models.kept.scores.tmp)])
            }      
            models.kept.scores.tmp <- Dweights
            rm(list=c('Dweights','DecayCount','WOrder'))          
          }
          
          ### Standardise model weights
          models.kept.scores.tmp <- models.kept.scores.tmp/sum(models.kept.scores.tmp, na.rm=T)
          
          model.bm <- new("EMwmean_biomod2_model",
                           model = models.kept.tmp,
                           model_name = model_name,
                           model_class = 'EMwmean',
                           model_options = Options,
                           resp_name = modeling.output@sp.name,
                           expl_var_names = modeling.output@expl.var.names,
                           expl_var_type = expl_var_type,
                           expl_var_range = expl_var_range,
                           modeling.id = modeling.output@modeling.id,
                           penalization_scores = models.kept.scores.tmp)        
        }
        
        #### Models Evaluation ####
        pred.bm <- predict(model.bm, expl, formal_predictions=needed_predictions$predictions[,model.bm@model, drop=F] )
        
        if(exists('eval.obs') & exists('eval.expl')){
          eval_pred.bm <- predict(model.bm, eval.expl)
        }
 
        
        # Model evaluation stuff =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= #
        if(length(eval.metric) > 0){
          cat("\n\t\t\tEvaluating Model stuff...")
 
          cross.validation <- sapply(eval.metric,
                                     Find.Optim.Stat,
                                     Fit = pred.bm,
                                     Obs = obs)
          
          rownames(cross.validation) <- c("Testing.data","Cutoff","Sensitivity", "Specificity")
          
          if(exists('eval_pred.bm')){
            
            true.evaluation <- sapply(eval.metric,
                                      function(x){
                                        return( Find.Optim.Stat(Stat = x,
                                                                Fit = eval_pred.bm,
                                                                Obs = eval.obs,
                                                                Fixed.thresh = cross.validation["Cutoff",x]) )
                                      })
            
            
            cross.validation <- rbind(cross.validation["Testing.data",], true.evaluation)
            
            rownames(cross.validation) <- c("Testing.data","Evaluating.data","Cutoff","Sensitivity", "Specificity")
          }
          
          ## store results
          cross.validation <- t(round(cross.validation,digits=3))
          model.bm@model_evaluation <- cross.validation
          
          ## remove useless objects
          rm(list=c('cross.validation') )
        }                           
        # End evaluation stuff =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= # 
        
        #### Var Importance calculation ####
        if (VarImport > 0){ # do Varimp stuff
          cat("\n\t\t\tEvaluating Predictor Contributions...", "\n")
          variables.importance <- variables_importance(model.bm, expl, nb_rand=VarImport)
          model.bm@model_variables_importance <- variables.importance$mat
          ## remove useless objects
          rm(list=c('variables.importance') )
        }
        
        #### Models saving #####
        assign(model_name,model.bm)
        save(list=model_name,file=file.path(modeling.output@sp.name,
                                            "models",
                                            modeling.output@modeling.id,
                                            model_name))
        
        #### Add to sumary objects ####
        EM@em.models <- c(EM@em.models, model.bm)
        EM@em.computed <- c(EM@em.computed, model_name)
        
        
      }
    } 
  }
  
  ### fix models names ###
  names(EM@em.models) <- EM@em.computed
  
  model.name <- paste(EM@sp.name, '.', EM@modeling.id, 'ensemble.models.out', sep="")
  assign(x=model.name,
         value=EM)
  save(list=model.name, 
       file=file.path(EM@sp.name,model.name))
  
  .bmCat("Done")  
  return(EM)
}

# -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= #

.BIOMOD_EnsembleModeling.check.args <- function(  modeling.output,
                                                   chosen.models,
                                                   eval.metric,
                                                   eval.metric.quality.threshold,
                                                   prob.mean,
                                                   prob.cv,
                                                   prob.ci,
                                                   prob.ci.alpha,
                                                   prob.median,
                                                   committee.averaging,
                                                   prob.mean.weight,
                                                   prob.mean.weight.decay,
                                                   em.by ){
  # 1. modeling.output checking
  if(!(inherits(modeling.output, "BIOMOD.models.out"))){
    stop("Invalid modeling.output argument !\nIt must be a 'BIOMOD.models.out' object")
  }
  
  # 2. chosen.models checking
  if(!length(chosen.models) | (length(chosen.models)==1 & chosen.models[1] == 'all')){ # select all models
    cat("\n   ! all models available will be included in ensemble.modeling")
    chosen.models <- modeling.output@models.computed
  } else{
    chosen.models.check <- chosen.models %in% modeling.output@models.computed
    if(sum(!chosen.models.check) > 0){
      stop(paste("Some selected models not exist : ", toString(chosen.models[!chosen.models.check]),
                 "\nPlease choose models in computed models ( ",
                 toString(modeling.output@models.computed), " )",sep=""))
    }
  }
  
  # 3. eval.metric checking
  if(!is.null(eval.metric)){
    if(!is.character(eval.metric)){
      stop("eval.metric must be a character vector or NULL")
    }
    if('all' %in% eval.metric){
      eval.metric <- dimnames(get_evaluations(modeling.output))[[1]]
    }
    eval.metric.check <- eval.metric %in% dimnames(get_evaluations(modeling.output))[[1]]
    if(sum(!eval.metric.check) > 0){
      stop(paste("Some selected evaluation metrics are not available : ", toString(eval.metric[!eval.metric.check]),
                 "\nPlease choose some in those computed yet ( ",
                 toString(dimnames(get_evaluations(modeling.output))[[1]]), " )",sep=""))
    }
  }
  
  # 4. eval.metric.quality.threshold
  if(!is.null(eval.metric)){
    if(!is.null(eval.metric.quality.threshold)){
      if(!is.numeric(eval.metric.quality.threshold)){
        stop("eval.metric.quality.threshold must be NULL or a numeric vector")
      }
      if(length(eval.metric) != length(eval.metric.quality.threshold)){
        stop("you must give as many eval.metric.quality.threshold than eval.metric (if you give ones)")
      }
      cat("\n   > Evaluation & Weighting methods summary :\n")
      cat(paste(eval.metric, eval.metric.quality.threshold,  sep = " over ", collapse = "\n      "), fill=TRUE, labels = "     ")
    } else{
      cat("\n   ! No eval.metric.quality.threshold -> All models will be kept for Ensemble Modeling")
      eval.metric.quality.threshold <- rep(0, length(eval.metric))
    }
  }
  
  # 5. check selected EM algo
  if( !is.logical(prob.mean) | !is.logical(prob.cv) | !is.logical(prob.ci) | !is.logical(prob.median) |
      !is.logical(committee.averaging) | !is.logical(prob.mean.weight) ){
    stop("prob.mean, prob.cv, prob.ci, prob.median, committee.averaging and prob.mean.weight arguments must be logical")
  }
  if(is.null(eval.metric)){
    if(committee.averaging | prob.mean.weight){
      stop("You must choose eval.metric if you want to compute Comitee Averaging or Probability wegthing mean algorithmes")
    }
  }
  
  # 6. alpha for Confident interval
  if(prob.ci){
    if(!is.numeric(prob.ci.alpha)){
      stop("prob.ci.alpha must be numeric")
    }
    if(prob.ci.alpha <= 0 | prob.ci.alpha>= 0.5){
      stop("prob.ci.alpha must be a numeric between 0 and 0.5")
    }
  }
  
  # 7. decay checking
  if(prob.mean.weight){
    if(is.numeric(prob.mean.weight.decay)){
      if(prob.mean.weight.decay < 0){
        stop("'prob.mean.weight.decay' should be either 'proportional' or a numeric value > 0")
      }
    } else{
      if(prob.mean.weight.decay != 'proportional'){
        stop("'prob.mean.weight.decay' should be either 'proportional' or a numeric value > 0")
      }
#       prob.mean.weight.decay <- 1
    }   
  }

  if(is.null(eval.metric)){
    eval.metric <- 'none'
  }
  
  # 8. by arg checking
  available.em.by <- c('PA_dataset', 'algo', 'all', 'PA_dataset+repet', 'PA_dataset+algo')
  if(!(em.by %in% available.em.by) ){
    stop("Invalid 'em.by' argument given. It must be one of : 'PA_dataset', 'algo', 'all', 'PA_dataset+repet' or 'PA_dataset+algo'")
  }
  
  
  return( list( modeling.output = modeling.output,
                chosen.models = chosen.models,
                eval.metric = eval.metric,
                eval.metric.quality.threshold = eval.metric.quality.threshold,
                prob.mean = prob.mean,
                prob.cv = prob.cv,
                prob.ci = prob.ci,
                prob.ci.alpha = prob.ci.alpha,
                prob.median = prob.median,
                committee.averaging = committee.averaging,
                prob.mean.weight = prob.mean.weight,
                prob.mean.weight.decay  = prob.mean.weight.decay,
                em.by = em.by))
  
}


# =-=-=-=-=-=-=-=- em.models.assembling function -=-=-=-=-=-=-=- #
.em.models.assembling <- function(chosen.models, em.by){
  assembl.list = list()
  
  if(em.by == 'PA_dataset'){
    for(dat in .extractModelNamesInfo(chosen.models, info='data.set')){
      assembl.list[[paste(dat,"_AllRun", sep="")]] <- chosen.models[grep(paste("_",dat,"_",sep=""), chosen.models)]
    }
    return(assembl.list)
  }
  
  if(em.by == 'algo'){
    for(algo in .extractModelNamesInfo(chosen.models, info='models')){
      assembl.list[[paste(algo,"_AllRun", sep="")]] <- chosen.models[grep(paste("_",algo,sep=""), chosen.models)]
    }
    return(assembl.list)
  }
  
  if(em.by == 'all'){
    assembl.list[["TotalConsensus"]] <- chosen.models
    return(assembl.list)
  }
  
  if(em.by == 'PA_dataset+repet'){
    for(dat in .extractModelNamesInfo(chosen.models, info='data.set')){
      for(repet in .extractModelNamesInfo(chosen.models, info='run.eval')){
        mod.tmp <- intersect(x=grep(paste("_",dat,"_",sep=""), chosen.models), 
                             y=grep(paste("_",repet,"_",sep=""), chosen.models))
        if(length(mod.tmp)){
          assembl.list[[paste(dat,"_",repet,'_AllAlgos', sep="")]] <- chosen.models[mod.tmp]
        }
      }
    }
    return(assembl.list)      
  }
  
  if(em.by == 'PA_dataset+algo'){
    for(dat in .extractModelNamesInfo(chosen.models, info='data.set')){
      for(algo in .extractModelNamesInfo(chosen.models, info='models')){
        mod.tmp <- intersect(x=grep(paste("_",dat,"_",sep=""), chosen.models), 
                             y=grep(paste("_",algo,sep=""), chosen.models))
        if(length(mod.tmp)){
          assembl.list[[paste(dat,"_AllRepet_",algo, sep="")]] <- chosen.models[mod.tmp]
        }
      }
    }
    return(assembl.list)      
  }
  
}
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- #



.get_needed_predictions <- function(modeling.output, em.by, models.kept, eval.metric, eval.metric.quality.threshold){
  out <- list(predictions = NULL,
              models.kept = NULL,
              models.kept.scores = NULL)
  for(eval.m in eval.metric){
    if( eval.m != 'none'){
      models.kept.scores <- unlist(lapply(models.kept, function(x){
        mod <- tail(unlist(strsplit(x,"_")), 3)[3]
        run <- tail(unlist(strsplit(x,"_")), 3)[2]
        dat <- tail(unlist(strsplit(x,"_")), 3)[1]
        # select evaluations scores obtained for Evaluation Data if exists or CV if not
        if(modeling.output@has.evaluation.data){
          return(get_evaluations(modeling.output)[eval.m, "Evaluating.data", mod, run, dat])
        } else{
          return(get_evaluations(modeling.output)[eval.m, "Testing.data", mod, run, dat])
        }
        
      }))
      ## set NA to -1
      if(!is.null(models.kept.scores)){
        models.kept.scores[is.na(models.kept.scores)] <- -1
      }
      out$models.kept[[eval.m]] <- models.kept[models.kept.scores > eval.metric.quality.threshold[which(eval.metric == eval.m)]]
      out$models.kept.scores[[eval.m]] <- models.kept.scores[models.kept.scores > eval.metric.quality.threshold[which(eval.metric == eval.m)]]
    } else{
      out$models.kept[[eval.m]] <- models.kept
    }
  }
  
  models.kept.union <- unique(unlist(out$models.kept))
  
  if(length(models.kept.union) ){
#     if(modeling.output@has.evaluation.data){
#       out$predictions <- as.data.frame(get_predictionsEval(modeling.output, as.data.frame = TRUE)[,models.kept.union, drop=F])
#     } else{
      ## load prediction on each PA dataset
      if(em.by %in% c("PA_dataset",'PA_dataset+algo','PA_dataset+repet')){
        out$predictions <- as.data.frame(get_predictions(modeling.output, as.data.frame = TRUE)[,models.kept.union, drop=F])
      } else{ ## redo prediction on full data.set
        cat("\n   ! Models projections for whole zonation required...")
        temp_name <- paste('tmp_',sub(".","",as.character(format(Sys.time(), "%OS6")), fixed=T),sep="")
        out$predictions <- BIOMOD_Projection(modeling.output = modeling.output,
                                             new.env = get_formal_data(modeling.output)@data.env.var,
                                             proj.name = temp_name,
                                             xy.new.env = get_formal_data(modeling.output)@coord,
                                             selected.models = models.kept.union,
                                             compress = TRUE,
                                             build.clamping.mask = F,
                                             do.stack=T, silent = T)@proj@val
        
        # transform array into data.frame
        out$predictions <- as.data.frame(out$predictions)
        names(out$predictions) <- unlist(lapply(strsplit(names(out$predictions),".", fixed=TRUE), 
                                                function(x){
                                                  return(paste(modeling.output@sp.name, x[3], x[2], x[1],sep="_"))
                                                }))
        # keep only wanted columns
        out$predictions <- out$predictions[,models.kept.union, drop=F]
        unlink(file.path(modeling.output@sp.name,paste("proj_", temp_name, sep="") ),recursive = TRUE, force = TRUE)
        cat("\n")
      }
#     }
    return(out)
  } else {
    cat("\n   ! No models kept due to treshold filtering... Ensemble Modeling was skip!")
    return(NULL)
  }
}



  