% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclu_optics.R
\name{hclu_optics}
\alias{hclu_optics}
\title{OPTICS hierarchical clustering algorithm}
\usage{
hclu_optics(
  dissimilarity,
  index = names(dissimilarity)[3],
  minPts = NULL,
  eps = NULL,
  xi = 0.05,
  minimum = FALSE,
  show_hierarchy = FALSE,
  algorithm_in_output = TRUE,
  ...
)
}
\arguments{
\item{dissimilarity}{the output object from \code{\link[=dissimilarity]{dissimilarity()}} or
\code{\link[=similarity_to_dissimilarity]{similarity_to_dissimilarity()}}, or a \code{dist} object.
If a \code{data.frame} is used, the first two columns represent pairs of
sites (or any pair of nodes), and the next column(s) are the dissimilarity
indices.}

\item{index}{name or number of the dissimilarity column to use. By default,
the third column name of \code{dissimilarity} is used.}

\item{minPts}{a \code{numeric} value specifying the minPts argument of
\link[dbscan:dbscan]{dbscan}). minPts is the minimum number of
points to form a dense region. By default, it is set to the natural
logarithm of the number of sites in \code{dissimilarity}.}

\item{eps}{a \code{numeric} value specifying the eps argument of
\link[dbscan:optics]{optics}). It is the upper limit of the size
of the epsilon neighborhood. Limiting the neighborhood size improves
performance and has no or very little impact on the ordering as long as it
is not set too low. If not specified (default behavior), the largest
minPts-distance in the data set is used which gives the same result as
infinity.}

\item{xi}{a \code{numeric} value specifying the steepness threshold to
identify clusters hierarchically using the Xi method
(see \link[dbscan:optics]{optics}).}

\item{minimum}{a \code{boolean} specifying if the hierarchy should be pruned
out from the output to only keep clusters at the "minimal" level, i.e.
only leaf / non-overlapping clusters.
If \code{TRUE}, then argument \code{show_hierarchy} should be \code{FALSE}.}

\item{show_hierarchy}{a \code{boolean} specifying if the hierarchy of
clusters should be included in the output. By default, the hierarchy is not
visible in the clusters obtained from OPTICS - it can only be visualized by
visualising the plot of the OPTICS object. If \code{show_hierarchy = TRUE},
then the output cluster \code{data.frame} will contain additional columns
showing the hierarchy of clusters.}

\item{algorithm_in_output}{a \code{boolean} indicating if the original output
of \link[dbscan:dbscan]{dbscan} should be returned in the output (\code{TRUE} by
default, see Value).}

\item{...}{you can add here further arguments to be passed to \code{optics()}
(see \link[dbscan:optics]{optics}).}
}
\value{
A \code{list} of class \code{bioregion.clusters} with five slots:
\enumerate{
\item{\strong{name}: \code{character} containing the name of the algorithm}
\item{\strong{args}: \code{list} of input arguments as provided by the user}
\item{\strong{inputs}: \code{list} of characteristics of the clustering process}
\item{\strong{algorithm}: \code{list} of all objects associated with the
clustering procedure, such as original cluster objects}
\item{\strong{clusters}: \code{data.frame} containing the clustering results}}

In the \code{algorithm} slot, if \code{algorithm_in_output = TRUE}, users can
find the output of \link[dbscan:optics]{optics}.
}
\description{
This function performs semi-hierarchical
clustering on the basis of dissimilarity with the OPTICS algorithm (Ordering
Points To Identify the Clustering Structure)
}
\details{
The OPTICS (Ordering points to identify the clustering structure) is a
semi-hierarchical clustering algorithm which orders the points in the
dataset such that points which are closest become neighbors, and calculates
a reachability distance for each point. Then, clusters can be extracted in a
hierarchical manner from this reachability distance, by identifying clusters
depending on changes in the relative cluster density. The reachability plot
should be explored to understand the clusters and their hierarchical nature,
by running plot on the output of the function
if \code{algorithm_in_output = TRUE}: \code{plot(object$algorithm)}.
We recommend reading \insertCite{Hahsler2019}{bioregion} to grasp the
algorithm, how it works, and what the clusters mean.

To extract the clusters, we use the
\link[dbscan:optics]{extractXi} function which is based on the
steepness of the reachability plot (see
\link[dbscan:optics]{optics})
}
\examples{
dissim <- dissimilarity(fishmat, metric = "all")
  
clust1 <- hclu_optics(dissim, index = "Simpson")
clust1

# Visualize the optics plot (the hierarchy of clusters is illustrated at the
# bottom)
plot(clust1$algorithm)

# Extract the hierarchy of clusters
clust1 <- hclu_optics(dissim, index = "Simpson", show_hierarchy = TRUE)
clust1

}
\references{
\insertRef{Hahsler2019}{bioregion}
}
\seealso{
\link{nhclu_dbscan}
}
\author{
Boris Leroy (\email{leroy.boris@gmail.com}),
Pierre Denelle (\email{pierre.denelle@gmail.com}) and
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
