% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tibble.R
\name{as-tibble-ape}
\alias{as-tibble-ape}
\alias{as_tibble.DNAbin}
\alias{as_tibble.AAbin}
\title{Convert DNAbin/AAbin to tibble}
\usage{
as_tibble.DNAbin(x, label = "label", sequence = "sequence", ...)

as_tibble.AAbin(x, label = "label", sequence = "sequence", ...)
}
\arguments{
\item{x}{a DNAbin or AAbin object.}

\item{label}{Name of the column that stores the sequence labels
in the returned tibble.}

\item{sequence}{Name of the column that stores the sequences in the
returned tibble.}

\item{...}{Not used.}
}
\value{
A tibble with two columns (if name is not NULL, the default) or one
column (otherwise).
}
\description{
These methods convert sequences from \pkg{ape}
formats DNAbin and AAbin to tibbles.
}
\examples{
require(ape)
require(tibble)
x <- rDNAbin(nrow = 10, ncol = 25)
as_tibble.DNAbin(x)


}
\seealso{
Other conversions: 
\code{\link{as-tibble-bioseq}},
\code{\link{as_AAbin}()},
\code{\link{as_DNAbin}()},
\code{\link{as_aa}()},
\code{\link{as_dna}()},
\code{\link{as_rna}()},
\code{\link{as_seqinr_alignment}()}
}
\concept{conversions}
