% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_string_operation.R
\name{seq_replace_position}
\alias{seq_replace_position}
\title{Replace a region between two positions in sequences}
\usage{
seq_replace_position(x, position_in, position_out, replacement)
}
\arguments{
\item{x}{a DNA, RNA or AA vector.}

\item{position_in}{an integer giving the position where to start to replace.}

\item{position_out}{an integer giving the position where to stop to replace.}

\item{replacement}{a vector of replacements.}
}
\value{
A vector of same class as \code{x}.
}
\description{
Replace a region between two positions in sequences
}
\examples{

x <- dna("ACGTTAGTGTAGCCGT", "CTCGAAATGA")
seq_replace_position(x, c(5, 2), 6, "-------")
}
\seealso{
\code{\link[stringi]{stri_replace}} from \pkg{stringi} and
\code{\link[stringr]{str_replace}} from \pkg{stringr}
for the underlying implementation.

Other string operations: 
\code{\link{seq-replace}},
\code{\link{seq_combine}()},
\code{\link{seq_count_pattern}()},
\code{\link{seq_crop_pattern}()},
\code{\link{seq_crop_position}()},
\code{\link{seq_detect_pattern}()},
\code{\link{seq_extract_pattern}()},
\code{\link{seq_extract_position}()},
\code{\link{seq_remove_pattern}()},
\code{\link{seq_remove_position}()},
\code{\link{seq_split_kmer}()},
\code{\link{seq_split_pattern}()}
}
\concept{string operations}
