.Random.seed <-
c(403L, 624L, 983982770L, -856550773L, 2069162064L, -82175983L, 
2133795486L, 1612627591L, 1188195612L, -752366739L, -408981686L, 
43835459L, -280626008L, 629660297L, -831785802L, -1131007041L, 
-660135180L, 496066917L, 1891770082L, 1172714747L, -553374720L, 
-124568575L, -1007412786L, 1771446263L, 1288577996L, 481298013L, 
-274411142L, 387510451L, -1276848552L, -2089149319L, -1733037594L, 
1564959535L, -1251815516L, 340761173L, -387324142L, 1260122987L, 
-2077664336L, 1249270769L, -10232578L, 1915673959L, -1372813700L, 
1123548493L, 901758890L, -2030953181L, 2021596168L, 238934633L, 
1711815446L, 1521315487L, -635525036L, -512946363L, 492878658L, 
725241307L, -511740064L, -2088601631L, 1735486510L, 75495127L, 
282629420L, 305049661L, -1634518566L, -1347459693L, -47198792L, 
-93186983L, 1824247878L, 1816090127L, 1009102084L, -1057439691L, 
-383149198L, 1856521291L, 1820426000L, -164196399L, 2127546206L, 
-522163129L, -444772388L, 1917001517L, 125976586L, -526923261L, 
1490152296L, -1267348919L, 1205973366L, -1221322369L, 1937956276L, 
46247205L, -1207466078L, 1200412347L, 1231712960L, -1529764927L, 
1156705934L, 1835482551L, 394638988L, 1457801757L, 1991234106L, 
-894285197L, -1459587816L, -798491591L, 659349158L, 1048754415L, 
1795242596L, -94972395L, -1233289262L, 30344491L, -80391568L, 
827503537L, 1711989182L, 636185383L, -1122186948L, -1350487795L, 
1258221674L, -255465757L, -1038718264L, -98063831L, -7317546L, 
1390556255L, 271303444L, -284738811L, 30311426L, 1930809243L, 
329063968L, -847724639L, 1796055278L, 201585815L, -953317396L, 
1464390653L, 1813158554L, 391749459L, -550581128L, -447491047L, 
-1174463226L, 46762959L, 55408580L, 199351285L, -671247310L, 
1791505931L, -484649520L, 717408145L, -374526946L, 386390535L, 
-1318915428L, 86651629L, 2051920074L, -1263242301L, 1378130472L, 
1028356617L, 1689005622L, -1972388033L, 1198610548L, 1337309413L, 
-942821278L, 571291771L, 686782848L, 1785711489L, -1269005490L, 
-1542579337L, 841484620L, 1003769309L, -19688710L, 1625121843L, 
865260504L, -1792173063L, 1651149670L, -1010053457L, -228432604L, 
2098319829L, -524167022L, -1412704533L, -1022359248L, 226413425L, 
172926590L, -437405465L, -358102020L, 968238285L, -1685659350L, 
1167814819L, 315914632L, 1473853929L, -1697827690L, -1768637921L, 
-592732716L, 172304069L, -484635454L, 1688932699L, 1580827872L, 
-458307743L, -948529746L, 1430106711L, 382548652L, -385960003L, 
990559066L, -1904895725L, -1509651656L, -1209183271L, -1440273978L, 
1749123471L, 1368916612L, 291420085L, 1877101810L, 1662117835L, 
635890832L, 8306513L, -1803071266L, 542443463L, 1027822940L, 
-811792723L, 1086464394L, -659366525L, 2046691560L, -1614222903L, 
294349558L, -1945557761L, -1087204556L, 1076724901L, 953456930L, 
-416851397L, 1951612992L, -1590840511L, 385079310L, -1689601737L, 
-545973236L, -12578403L, -1194323014L, -1554366989L, -1571032424L, 
-1584727111L, 1724708902L, -1293769617L, 1715884004L, -935293547L, 
813101394L, -892180309L, -2105966608L, 649765681L, 552545086L, 
-1342847321L, 697142972L, 89577613L, -2011721238L, -1087194525L, 
1769556040L, -418215511L, -2072063658L, 1535442911L, 173947028L, 
1323750021L, -1173596798L, -239463653L, 404007840L, 14978849L, 
-512996754L, 1307389975L, -1569215124L, -619684995L, -1673815014L, 
-1094495533L, 7408120L, 570332057L, -1175193978L, 1114060623L, 
-1580905148L, -584101003L, -644364878L, -1186637429L, 1000325968L, 
-1624606959L, 337524126L, -628623993L, -606177252L, -715416979L, 
463417930L, 1716717379L, 790509480L, 2075007369L, -79730762L, 
-775927105L, 92704244L, -806809499L, 1675379170L, 1755003899L, 
-497694976L, 1623939841L, 829942990L, -1596123401L, 573370060L, 
-1796762275L, -1788521350L, 468244403L, 68931928L, -2059396231L, 
288629990L, -1853408721L, -1586693468L, -945616555L, 777832978L, 
-1599948181L, -1607354704L, -2067383567L, -1632866306L, 1103336551L, 
747508092L, -165458867L, 829489834L, 1464583203L, -2067474680L, 
663984489L, -916115946L, -1754069601L, 604214100L, -1733542331L, 
1063018050L, -872229669L, 1475252832L, 433723105L, -575750354L, 
600993239L, -856891348L, 20823869L, -530236198L, 302173331L, 
1563707576L, -1824025767L, 639992646L, -151343857L, 781539332L, 
991145781L, -35783054L, -1893561525L, -351839728L, -293212463L, 
-1120806306L, -480206009L, -1611375908L, -635048403L, -1952120054L, 
928313603L, -1874516376L, 817563977L, -1903680394L, 827666559L, 
86853812L, -1163371483L, 1638181538L, 942202299L, -373879360L, 
-2130132287L, -2002206322L, -1031457609L, -1123057268L, -1333077731L, 
1163089210L, 340341107L, 663908376L, -1878197447L, -27258458L, 
-1518759953L, 1050043748L, 653870357L, 590570194L, 788319275L, 
1123593584L, -278818127L, 944141502L, 420946471L, 1718178876L, 
-1344569331L, 2018718570L, -945386013L, -478730808L, 1495034153L, 
910183126L, 2018143L, 1952165396L, -2091554299L, -338876670L, 
1699042971L, -192464608L, -414228831L, -1593969682L, -995267689L, 
-1192439060L, -280567043L, 407346586L, -1309407661L, -351385736L, 
998789913L, -344207354L, -1413750065L, -221764924L, -1228158219L, 
-2055932110L, -966165237L, -1159876400L, -1773066607L, -1534968034L, 
-1734405881L, 1548025244L, 1639711213L, -778857526L, -445080893L, 
2083706152L, -558909175L, -131751626L, 1082644031L, 1759953780L, 
2083219429L, 183358306L, -1483718789L, -1053354880L, -1717179775L, 
1631999566L, -838659465L, 853333068L, -974529315L, 962205178L, 
-1774499021L, -1686122792L, -776889607L, -1961836954L, -193354321L, 
-1736273884L, 1375944917L, 398113682L, 933273067L, 1368286256L, 
-296965519L, 1652373886L, 1940942823L, 165631740L, -1774226483L, 
-42064854L, -1979508829L, -1001376632L, 2070739177L, 1473259414L, 
189288735L, 103188692L, 1789023685L, -132206654L, -280913829L, 
-2069979168L, -519805343L, -803608402L, -566351529L, 1228375468L, 
-118765891L, 346209882L, -2007564269L, -1732311496L, 176214745L, 
-961094458L, 1181407375L, -1457672828L, -1676171595L, -652431374L, 
14298827L, -236796016L, -28565935L, -1630575650L, 402865863L, 
-1550819236L, -1344416339L, -299178870L, -897710973L, -1851309080L, 
1699489993L, 618126838L, 1427651583L, -1686962636L, 1345467301L, 
-126370782L, -929996485L, 1603656512L, 40030785L, -1072649458L, 
1360441399L, -967514356L, 147103901L, -1573284166L, 1803494643L, 
-1364988520L, 435026617L, -737793242L, 1145535343L, -906921244L, 
1954610325L, -726477742L, 1011756971L, 1924324080L, -918060495L, 
1376828990L, 1330609575L, 162535868L, -854644851L, 565302506L, 
-668901021L, 638583624L, 1313163433L, 2060764246L, -290482465L, 
-1541135468L, 1783824773L, 1561393282L, 1538759195L, 1593099936L, 
1052323361L, -809329298L, -565926121L, 546109548L, 837577341L, 
1714855706L, 1055635923L, 352748792L, -1343155559L, 882289030L, 
1825017423L, -866781116L, -155762059L, 563423410L, -1607163765L, 
-1764319664L, 1312216593L, 1087981726L, 1062022279L, -929660132L, 
-934581907L, -1574242998L, 2436675L, 794981032L, 1682987145L, 
-1050748234L, -2067373633L, -946734860L, 847036261L, -2096995102L, 
1827422971L, 2073256448L, -755009023L, 1774698446L, -1719661065L, 
2050472396L, 1826301021L, 1890703226L, 500481715L, 1874775128L, 
-125691271L, -1241491482L, 446894383L, -1381816924L, 2050127957L, 
-488919790L, 2126872939L, 220598704L, -2012079631L, -71236866L, 
1773423463L, 412851324L, 940219213L, 95307178L, -1413387485L, 
-948530680L, 1365596265L, -1408360170L, -1609261921L, -652968364L, 
1579642181L, -748420798L, 1550277595L, -1706447520L, -131222047L, 
-994569682L, -226433833L, -1582486740L, 1846070845L, 1573076954L, 
1064448915L, -828062792L, -1684467111L, 1910191686L, -2070805489L, 
-1758395644L, -1838506443L, 1201561970L, -969354677L, 1886991632L, 
1842433489L, -547361442L, -1405298105L, -568891940L, 1858387245L, 
1850983946L, 1613633539L, 1948541288L, 998000713L, 981112694L, 
-1521334401L, -670846028L, -557118683L, -1018311262L, 643884219L, 
-1947227968L, -482614847L, -483683186L, -1258345545L, 289754252L, 
-1511167971L, 1434638394L, -151250829L, -1383044328L, -1121060295L, 
-843103066L, -1119066385L, -564686748L, 249017365L, -1963637294L, 
13013803L, 1202194544L, -227774031L, 340658110L, 1084152103L, 
-1453203652L, 2062667533L, -1976338838L, -1096600349L, 658759880L, 
-997382103L, -1204011562L, -717790625L, -273180396L, -505439995L
)

year <- function(date, trunc=FALSE, year.length=365.24) {
    stopifnot(class(date)=="Date")
    year <- as.numeric(format(date,"%Y"))
    if (trunc) return(year)
    start <- as.Date(sprintf("%i-01-01",year))
    year + as.numeric(date-start)/year.length
}

## confint.anova <- function(x, level = 0.95) {
##       if(!all(c("value","vcov") %in% names(attributes(x))))
##         stop("confint.anova is only intended for linearHypothesis objects")
##       cf <- as.vector(attr(x, "value"))
##       vcov <- attr(x, "vcov")
##       ses <- sqrt(diag(vcov))
##       a <- (1 - level)/2
##       a <- c(a, 1 - a)
##       pct <- format.perc(a, 3)
##       fac <- qnorm(a)
##       ci <- cbind(cf, cf + ses %o% fac)
##       dimnames(ci) <- list(rownames(vcov), c("Estimate",pct))
##       ci
##   }

updateList <- function(object, ...) {
    revised <- list(...)
    for (name in setdiff(names(object),names(revised)))
        revised[[name]] <- object[[name]]
    revised
}

format_perc <- 
    function (probs, digits) 
        paste(format(100 * probs, trim = TRUE, scientific = FALSE, digits = digits), 
              "%")
